/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.utils;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.metrics.util.SystemResourcesCounter;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SystemResourcesCounterTest {
    private static final double EPSILON = 0.01;

    SystemResourcesCounterTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testObtainAnyMetrics() throws InterruptedException {
        SystemResourcesCounter systemResources = new SystemResourcesCounter(Time.milliseconds((long)10L));
        double initialCpuIdle = systemResources.getCpuIdle();
        systemResources.start();
        try {
            double cpuIdle;
            do {
                Thread.sleep(1L);
                cpuIdle = systemResources.getCpuIdle();
            } while (systemResources.isAlive() && (initialCpuIdle == cpuIdle || Double.isNaN(cpuIdle) || cpuIdle == 0.0));
        }
        finally {
            systemResources.shutdown();
            systemResources.join();
        }
        double totalCpuUsage = systemResources.getCpuIrq() + systemResources.getCpuNice() + systemResources.getCpuSoftIrq() + systemResources.getCpuSys() + systemResources.getCpuUser() + systemResources.getIOWait() + systemResources.getCpuSteal();
        ((AbstractIntegerAssert)Assertions.assertThat((int)systemResources.getProcessorsCount()).withFailMessage("There should be at least one processor", new Object[0])).isGreaterThan(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)systemResources.getNetworkInterfaceNames().length).withFailMessage("There should be at least one network interface", new Object[0])).isGreaterThan(0);
        Assertions.assertThat((double)(totalCpuUsage + systemResources.getCpuIdle())).isCloseTo(100.0, Assertions.within((Double)0.01));
    }
}

