/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.GateBuffersSpec;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateSpecUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class GateBuffersSpecTest {
    GateBuffersSpecTest() {
    }

    private static ResultPartitionType[] parameters() {
        return ResultPartitionType.values();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithSufficientRequiredBuffers(ResultPartitionType partitionType) {
        int numInputChannels = 499;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        int minFloating = 1;
        int maxFloating = 8;
        int numExclusivePerChannel = 2;
        int targetTotalBuffersPerGate = 1006;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, minFloating, maxFloating, numExclusivePerChannel, targetTotalBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithOneExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 500;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        boolean isPipeline = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType);
        int minFloating = isPipeline ? 1 : 500;
        int maxFloating = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 8 : 508;
        int numExclusivePerChannel = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 2 : 1;
        int targetTotalBuffersPerGate = 1008;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, minFloating, maxFloating, numExclusivePerChannel, targetTotalBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testUpperBoundaryCalculationWithOneExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 999;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        int minFloating = 1;
        int maxFloating = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 8 : 1007;
        int numExclusivePerChannel = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 2 : 1;
        int targetTotalBuffersPerGate = 2006;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, minFloating, maxFloating, numExclusivePerChannel, targetTotalBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testBoundaryCalculationWithoutExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 1000;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        boolean isPipeline = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType);
        int minFloating = isPipeline ? 1 : 1000;
        int maxFloating = isPipeline ? 8 : numInputChannels * 2 + 8;
        int numExclusivePerChannel = isPipeline ? 2 : 0;
        int targetTotalBuffersPerGate = 2008;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, minFloating, maxFloating, numExclusivePerChannel, targetTotalBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithConfiguredZeroExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 1001;
        int numExclusiveBuffersPerChannel = 0;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, numExclusiveBuffersPerChannel);
        int minFloating = 1;
        int maxFloating = 8;
        int numExclusivePerChannel = 0;
        int targetTotalBuffersPerGate = 8;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, minFloating, maxFloating, numExclusivePerChannel, targetTotalBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testConfiguredMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        boolean enabledTieredStorage = false;
        Optional<Integer> configuredMaxRequiredBuffers = Optional.of(100);
        int effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, configuredMaxRequiredBuffers, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo((Object)configuredMaxRequiredBuffers.get());
        enabledTieredStorage = true;
        effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, configuredMaxRequiredBuffers, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo((Object)configuredMaxRequiredBuffers.get());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testDefaultMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        Optional emptyConfig = Optional.empty();
        boolean enabledTieredStorage = false;
        int effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, emptyConfig, (boolean)enabledTieredStorage);
        int expectEffectiveMaxRequiredBuffers = GateBuffersSpecTest.isPipelinedOrHybridResultPartitionNewMode(partitionType, enabledTieredStorage) ? Integer.MAX_VALUE : 1000;
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo(expectEffectiveMaxRequiredBuffers);
        enabledTieredStorage = true;
        expectEffectiveMaxRequiredBuffers = GateBuffersSpecTest.isPipelinedOrHybridResultPartitionNewMode(partitionType, enabledTieredStorage) ? Integer.MAX_VALUE : 1000;
        effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, emptyConfig, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo(expectEffectiveMaxRequiredBuffers);
    }

    private static void checkBuffersInGate(GateBuffersSpec gateBuffersSpec, int minFloating, int maxFloating, int numExclusivePerChannel, int targetTotalBuffersPerGate) {
        Assertions.assertThat((int)gateBuffersSpec.getRequiredFloatingBuffers()).isEqualTo(minFloating);
        Assertions.assertThat((int)gateBuffersSpec.getTotalFloatingBuffers()).isEqualTo(maxFloating);
        Assertions.assertThat((int)gateBuffersSpec.getEffectiveExclusiveBuffersPerChannel()).isEqualTo(numExclusivePerChannel);
        Assertions.assertThat((int)gateBuffersSpec.targetTotalBuffersPerGate()).isEqualTo(targetTotalBuffersPerGate);
    }

    private static GateBuffersSpec createGateBuffersSpec(int numInputChannels, ResultPartitionType partitionType) {
        return GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, 2);
    }

    private static GateBuffersSpec createGateBuffersSpec(int numInputChannels, ResultPartitionType partitionType, int numExclusiveBuffersPerChannel) {
        return InputGateSpecUtils.createGateBuffersSpec(GateBuffersSpecTest.getMaxRequiredBuffersPerGate(partitionType), (int)numExclusiveBuffersPerChannel, (int)8, (ResultPartitionType)partitionType, (int)numInputChannels, (boolean)false);
    }

    private static Optional<Integer> getMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        return GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? Optional.of(Integer.MAX_VALUE) : Optional.of(1000);
    }

    private static boolean isPipelinedOrHybridResultPartition(ResultPartitionType partitionType) {
        return partitionType.isPipelinedOrPipelinedBoundedResultPartition() || partitionType.isHybridResultPartition();
    }

    private static boolean isPipelinedOrHybridResultPartitionNewMode(ResultPartitionType partitionType, Boolean enabledTieredStorage) {
        return partitionType.isPipelinedOrPipelinedBoundedResultPartition() || partitionType.isHybridResultPartition() && enabledTieredStorage == false;
    }
}

