/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.flink.runtime.rest.HttpHeader;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public interface MessageHeaders<R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends UntypedResponseMessageHeaders<R, M> {
    public Class<P> getResponseClass();

    public HttpResponseStatus getResponseStatusCode();

    default public Collection<Class<?>> getResponseTypeParameters() {
        return Collections.emptyList();
    }

    public String getDescription();

    default public String operationId() {
        if (this.getHttpMethod() != HttpMethodWrapper.GET) {
            throw new UnsupportedOperationException("The default implementation is only supported for GET calls. Please override 'operationId()'.");
        }
        String className = this.getClass().getSimpleName();
        int headersSuffixStart = className.lastIndexOf("Headers");
        if (headersSuffixStart == -1) {
            throw new IllegalStateException("Expect name of class " + this.getClass() + " to end on 'Headers'. Please rename the class or override 'operationId()'.");
        }
        return this.getHttpMethod().name().toLowerCase(Locale.ROOT) + className.substring(0, headersSuffixStart);
    }

    default public Collection<HttpHeader> getCustomHeaders() {
        return Collections.emptyList();
    }
}

