/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import java.time.Duration;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.util.Preconditions;

public class RestHandlerConfiguration {
    private final long refreshInterval;
    private final int checkpointHistorySize;
    private final Duration checkpointCacheExpireAfterWrite;
    private final int checkpointCacheSize;
    private final Time timeout;
    private final File webUiDir;
    private final boolean webSubmitEnabled;
    private final boolean webCancelEnabled;
    private final boolean webRescaleEnabled;

    public RestHandlerConfiguration(long refreshInterval, int checkpointHistorySize, Duration checkpointCacheExpireAfterWrite, int checkpointCacheSize, Time timeout, File webUiDir, boolean webSubmitEnabled, boolean webCancelEnabled, boolean webRescaleEnabled) {
        Preconditions.checkArgument((refreshInterval > 0L ? 1 : 0) != 0, (Object)"The refresh interval (ms) should be larger than 0.");
        this.refreshInterval = refreshInterval;
        this.checkpointHistorySize = checkpointHistorySize;
        this.checkpointCacheExpireAfterWrite = checkpointCacheExpireAfterWrite;
        this.checkpointCacheSize = checkpointCacheSize;
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.webUiDir = (File)Preconditions.checkNotNull((Object)webUiDir);
        this.webSubmitEnabled = webSubmitEnabled;
        this.webCancelEnabled = webCancelEnabled;
        this.webRescaleEnabled = webRescaleEnabled;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getCheckpointHistorySize() {
        return this.checkpointHistorySize;
    }

    public Duration getCheckpointCacheExpireAfterWrite() {
        return this.checkpointCacheExpireAfterWrite;
    }

    public int getCheckpointCacheSize() {
        return this.checkpointCacheSize;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public File getWebUiDir() {
        return this.webUiDir;
    }

    public boolean isWebSubmitEnabled() {
        return this.webSubmitEnabled;
    }

    public boolean isWebCancelEnabled() {
        return this.webCancelEnabled;
    }

    public boolean isWebRescaleEnabled() {
        return this.webRescaleEnabled;
    }

    public static RestHandlerConfiguration fromConfiguration(Configuration configuration) {
        long refreshInterval = configuration.getLong(WebOptions.REFRESH_INTERVAL);
        int checkpointHistorySize = configuration.getInteger(WebOptions.CHECKPOINTS_HISTORY_SIZE);
        Duration checkpointStatsSnapshotCacheExpireAfterWrite = configuration.getOptional(RestOptions.CACHE_CHECKPOINT_STATISTICS_TIMEOUT).orElse(Duration.ofMillis(refreshInterval));
        int checkpointStatsSnapshotCacheSize = (Integer)configuration.get(RestOptions.CACHE_CHECKPOINT_STATISTICS_SIZE);
        Time timeout = Time.milliseconds((long)configuration.getLong(WebOptions.TIMEOUT));
        String rootDir = "flink-web-ui";
        File webUiDir = new File(configuration.getString(WebOptions.TMP_DIR), "flink-web-ui");
        boolean webSubmitEnabled = configuration.getBoolean(WebOptions.SUBMIT_ENABLE);
        boolean webCancelEnabled = configuration.getBoolean(WebOptions.CANCEL_ENABLE);
        boolean webRescaleSupported = ClusterOptions.isAdaptiveSchedulerEnabled((Configuration)configuration) && !ClusterOptions.isReactiveModeEnabled((Configuration)configuration);
        boolean webRescaleEnabled = webRescaleSupported && configuration.getBoolean(WebOptions.RESCALE_ENABLE);
        return new RestHandlerConfiguration(refreshInterval, checkpointHistorySize, checkpointStatsSnapshotCacheExpireAfterWrite, checkpointStatsSnapshotCacheSize, timeout, webUiDir, webSubmitEnabled, webCancelEnabled, webRescaleEnabled);
    }
}

