/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteStorageScanner;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierMasterAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierProducerAgent;

public class RemoteTierFactory
implements TierFactory {
    private final int numBytesPerSegment;
    private final int bufferSizeBytes;
    private final String remoteStoragePath;

    public RemoteTierFactory(int numBytesPerSegment, int bufferSizeBytes, String remoteStorageBasePath) {
        this.numBytesPerSegment = numBytesPerSegment;
        this.bufferSizeBytes = bufferSizeBytes;
        this.remoteStoragePath = SegmentPartitionFile.getTieredStoragePath(remoteStorageBasePath);
    }

    @Override
    public TierMasterAgent createMasterAgent(TieredStorageResourceRegistry resourceRegistry) {
        return new RemoteTierMasterAgent(this.remoteStoragePath, resourceRegistry);
    }

    @Override
    public TierProducerAgent createProducerAgent(int numSubpartitions, TieredStoragePartitionId partitionID, String dataFileBasePath, boolean isBroadcastOnly, TieredStorageMemoryManager storageMemoryManager, TieredStorageNettyService nettyService, TieredStorageResourceRegistry resourceRegistry, BatchShuffleReadBufferPool bufferPool, ScheduledExecutorService ioExecutor, int maxRequestedBuffers, Duration bufferRequestTimeout, int maxBufferReadAhead) {
        SegmentPartitionFileWriter partitionFileWriter = SegmentPartitionFile.createPartitionFileWriter(this.remoteStoragePath, numSubpartitions);
        return new RemoteTierProducerAgent(partitionID, numSubpartitions, this.numBytesPerSegment, this.bufferSizeBytes, isBroadcastOnly, partitionFileWriter, storageMemoryManager, resourceRegistry);
    }

    @Override
    public TierConsumerAgent createConsumerAgent(List<TieredStorageConsumerSpec> tieredStorageConsumerSpecs, TieredStorageNettyService nettyService) {
        SegmentPartitionFileReader partitionFileReader = SegmentPartitionFile.createPartitionFileReader(this.remoteStoragePath);
        RemoteStorageScanner remoteStorageScanner = new RemoteStorageScanner(this.remoteStoragePath);
        return new RemoteTierConsumerAgent(remoteStorageScanner, partitionFileReader, this.bufferSizeBytes);
    }
}

