/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexCache;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexSpilledRegionManagerImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileRegionWriteReadUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class ProducerMergedPartitionFileIndex {
    private final Path indexFilePath;
    @GuardedBy(value="lock")
    private final FileDataIndexCache<FixedSizeRegion> indexCache;
    private final Object lock = new Object();

    public ProducerMergedPartitionFileIndex(int numSubpartitions, Path indexFilePath, int regionGroupSizeInBytes, long numRetainedInMemoryRegionsMax) {
        this.indexFilePath = indexFilePath;
        this.indexCache = new FileDataIndexCache<FixedSizeRegion>(numSubpartitions, indexFilePath, numRetainedInMemoryRegionsMax, new FileDataIndexSpilledRegionManagerImpl.Factory<FixedSizeRegion>(regionGroupSizeInBytes, numRetainedInMemoryRegionsMax, 24, ProducerMergedPartitionFileDataIndexRegionHelper.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBuffers(List<FlushedBuffer> buffers) {
        if (buffers.isEmpty()) {
            return;
        }
        Map<Integer, List<FixedSizeRegion>> convertedRegions = ProducerMergedPartitionFileIndex.convertToRegions(buffers);
        Object object = this.lock;
        synchronized (object) {
            convertedRegions.forEach(this.indexCache::put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<FixedSizeRegion> getRegion(TieredStorageSubpartitionId subpartitionId, int bufferIndex) {
        Object object = this.lock;
        synchronized (object) {
            return this.indexCache.get(subpartitionId.getSubpartitionId(), bufferIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.indexCache.close();
                IOUtils.deleteFileQuietly((Path)this.indexFilePath);
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    private static Map<Integer, List<FixedSizeRegion>> convertToRegions(List<FlushedBuffer> buffers) {
        FlushedBuffer firstBufferInRegion;
        HashMap<Integer, List<FixedSizeRegion>> subpartitionRegionMap = new HashMap<Integer, List<FixedSizeRegion>>();
        Iterator<FlushedBuffer> iterator = buffers.iterator();
        FlushedBuffer lastBufferInRegion = firstBufferInRegion = iterator.next();
        while (iterator.hasNext()) {
            FlushedBuffer currentBuffer = iterator.next();
            if (currentBuffer.getSubpartitionId() != firstBufferInRegion.getSubpartitionId() || currentBuffer.getBufferIndex() != lastBufferInRegion.getBufferIndex() + 1) {
                ProducerMergedPartitionFileIndex.addRegionToMap(firstBufferInRegion, lastBufferInRegion, subpartitionRegionMap);
                firstBufferInRegion = currentBuffer;
            }
            lastBufferInRegion = currentBuffer;
        }
        ProducerMergedPartitionFileIndex.addRegionToMap(firstBufferInRegion, lastBufferInRegion, subpartitionRegionMap);
        return subpartitionRegionMap;
    }

    private static void addRegionToMap(FlushedBuffer firstBufferInRegion, FlushedBuffer lastBufferInRegion, Map<Integer, List<FixedSizeRegion>> subpartitionRegionMap) {
        Preconditions.checkArgument((firstBufferInRegion.getSubpartitionId() == lastBufferInRegion.getSubpartitionId() ? 1 : 0) != 0);
        Preconditions.checkArgument((firstBufferInRegion.getBufferIndex() <= lastBufferInRegion.getBufferIndex() ? 1 : 0) != 0);
        subpartitionRegionMap.computeIfAbsent(firstBufferInRegion.getSubpartitionId(), ArrayList::new).add(new FixedSizeRegion(firstBufferInRegion.getBufferIndex(), firstBufferInRegion.getFileOffset(), lastBufferInRegion.getFileOffset() + lastBufferInRegion.getBufferSizeBytes(), lastBufferInRegion.getBufferIndex() - firstBufferInRegion.getBufferIndex() + 1));
    }

    public static class FixedSizeRegion
    implements FileDataIndexRegionHelper.Region {
        public static final int REGION_SIZE = 24;
        private final int firstBufferIndex;
        private final long regionStartOffset;
        private final long regionEndOffset;
        private final int numBuffers;

        public FixedSizeRegion(int firstBufferIndex, long regionStartOffset, long regionEndOffset, int numBuffers) {
            this.firstBufferIndex = firstBufferIndex;
            this.regionStartOffset = regionStartOffset;
            this.regionEndOffset = regionEndOffset;
            this.numBuffers = numBuffers;
        }

        @Override
        public boolean containBuffer(int bufferIndex) {
            return bufferIndex >= this.firstBufferIndex && bufferIndex < this.firstBufferIndex + this.numBuffers;
        }

        @Override
        public int getSize() {
            return 24 + this.numBuffers;
        }

        @Override
        public long getRegionStartOffset() {
            return this.regionStartOffset;
        }

        @Override
        public long getRegionEndOffset() {
            return this.regionEndOffset;
        }

        @Override
        public int getNumBuffers() {
            return this.numBuffers;
        }

        @Override
        public int getFirstBufferIndex() {
            return this.firstBufferIndex;
        }
    }

    static class ProducerMergedPartitionFileDataIndexRegionHelper
    implements FileDataIndexRegionHelper<FixedSizeRegion> {
        private final ByteBuffer regionBuffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer(24);
        static final ProducerMergedPartitionFileDataIndexRegionHelper INSTANCE = new ProducerMergedPartitionFileDataIndexRegionHelper();

        private ProducerMergedPartitionFileDataIndexRegionHelper() {
        }

        @Override
        public void writeRegionToFile(FileChannel channel, FixedSizeRegion region) throws IOException {
            FileRegionWriteReadUtils.writeFixedSizeRegionToFile(channel, this.regionBuffer, region);
        }

        @Override
        public FixedSizeRegion readRegionFromFile(FileChannel channel, long fileOffset) throws IOException {
            return FileRegionWriteReadUtils.readFixedSizeRegionFromFile(channel, this.regionBuffer, fileOffset);
        }
    }

    static class FlushedBuffer {
        private final int subpartitionId;
        private final int bufferIndex;
        private final long fileOffset;
        private final long bufferSizeBytes;

        FlushedBuffer(int subpartitionId, int bufferIndex, long fileOffset, long bufferSizeBytes) {
            this.subpartitionId = subpartitionId;
            this.bufferIndex = bufferIndex;
            this.fileOffset = fileOffset;
            this.bufferSizeBytes = bufferSizeBytes;
        }

        int getSubpartitionId() {
            return this.subpartitionId;
        }

        int getBufferIndex() {
            return this.bufferIndex;
        }

        long getFileOffset() {
            return this.fileOffset;
        }

        long getBufferSizeBytes() {
            return this.bufferSizeBytes;
        }
    }
}

