/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.util.SlotSelectionStrategyUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SlotSelectionStrategyUtilsTest
extends TestLogger {
    @Test
    public void testCreatePreviousAllocationSlotSelectionStrategyForLocalRecoveryStreamingJob() {
        Configuration configuration = new Configuration();
        configuration.set(CheckpointingOptions.LOCAL_RECOVERY, (Object)true);
        SlotSelectionStrategy slotSelectionStrategy = SlotSelectionStrategyUtils.selectSlotSelectionStrategy((JobType)JobType.STREAMING, (Configuration)configuration);
        MatcherAssert.assertThat((Object)slotSelectionStrategy, (Matcher)Matchers.instanceOf(PreviousAllocationSlotSelectionStrategy.class));
    }

    @Test
    public void testCreateLocationPreferenceSlotSelectionStrategyForLocalRecoveryBatchJob() {
        Configuration configuration = new Configuration();
        configuration.set(CheckpointingOptions.LOCAL_RECOVERY, (Object)true);
        SlotSelectionStrategy slotSelectionStrategy = SlotSelectionStrategyUtils.selectSlotSelectionStrategy((JobType)JobType.BATCH, (Configuration)configuration);
        MatcherAssert.assertThat((Object)slotSelectionStrategy, (Matcher)Matchers.instanceOf(LocationPreferenceSlotSelectionStrategy.class));
    }
}

