/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.FlinkSecurityManager;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class FlinkSecurityManagerITCase
extends TestLogger {
    @Before
    public void ensureSupportedOS() {
        Assume.assumeTrue((OperatingSystem.isLinux() || OperatingSystem.isMac() ? 1 : 0) != 0);
    }

    @Test
    public void testForcedJVMExit() throws Exception {
        ForcedJVMExitProcess testProcess = new ForcedJVMExitProcess(ForcedExitEntryPoint.class);
        testProcess.startProcess();
        try {
            testProcess.waitFor();
            Assert.assertThat((Object)testProcess.exitCode(), (Matcher)CoreMatchers.is((Object)222));
        }
        finally {
            testProcess.destroy();
        }
    }

    @Test
    public void testIgnoredJVMExit() throws Exception {
        ForcedJVMExitProcess testProcess = new ForcedJVMExitProcess(IgnoredExitEntryPoint.class);
        testProcess.startProcess();
        try {
            testProcess.waitFor();
            Assert.assertThat((Object)testProcess.exitCode(), (Matcher)CoreMatchers.is((Object)0));
        }
        finally {
            testProcess.destroy();
        }
    }

    public static final class IgnoredExitEntryPoint {
        public static void main(String[] args) throws Exception {
            Configuration configuration = new Configuration();
            configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
            FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
            FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
            try {
                System.exit(123);
            }
            catch (Throwable t) {
                System.err.println("Caught exception during system exit with message: " + t.getMessage());
            }
        }
    }

    public static final class ForcedExitEntryPoint {
        public static void main(String[] args) throws Exception {
            Configuration configuration = new Configuration();
            configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
            FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
            FlinkSecurityManager.forceProcessExit((int)222);
            System.exit(0);
        }
    }

    private static final class ForcedJVMExitProcess
    extends TestJvmProcess {
        private final Class<?> entryPointName;

        private ForcedJVMExitProcess(Class<?> entryPointName) throws Exception {
            this.entryPointName = entryPointName;
        }

        @Override
        public String getName() {
            return this.getEntryPointClassName();
        }

        @Override
        public String[] getJvmArgs() {
            return new String[0];
        }

        @Override
        public String getEntryPointClassName() {
            return this.entryPointName.getName();
        }
    }
}

