/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.rpc.MainThreadExecutable;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.util.Preconditions;

public class ThreadSafeTaskSlotTable<T extends TaskSlotPayload>
implements TaskSlotTable<T> {
    private final TaskSlotTable<T> taskSlotTable;
    private final MainThreadExecutable mainThreadExecutable;

    public ThreadSafeTaskSlotTable(TaskSlotTable<T> taskSlotTable, MainThreadExecutable mainThreadExecutable) {
        this.taskSlotTable = (TaskSlotTable)Preconditions.checkNotNull(taskSlotTable);
        this.mainThreadExecutable = (MainThreadExecutable)Preconditions.checkNotNull((Object)mainThreadExecutable);
    }

    private void runAsync(Runnable runnable) {
        this.mainThreadExecutable.runAsync(runnable);
    }

    private <V> V callAsync(Callable<V> callable) {
        try {
            return (V)this.mainThreadExecutable.callAsync(callable, Duration.ofDays(1L)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(SlotActions initialSlotActions, ComponentMainThreadExecutor mainThreadExecutor) {
        this.runAsync(() -> this.taskSlotTable.start(initialSlotActions, mainThreadExecutor));
    }

    public Set<AllocationID> getAllocationIdsPerJob(JobID jobId) {
        return this.callAsync(() -> this.taskSlotTable.getAllocationIdsPerJob(jobId));
    }

    public Set<AllocationID> getActiveTaskSlotAllocationIds() {
        return this.callAsync(() -> this.taskSlotTable.getActiveTaskSlotAllocationIds());
    }

    public Set<AllocationID> getActiveTaskSlotAllocationIdsPerJob(JobID jobId) {
        return this.callAsync(() -> this.taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId));
    }

    public SlotReport createSlotReport(ResourceID resourceId) {
        return this.callAsync(() -> this.taskSlotTable.createSlotReport(resourceId));
    }

    public boolean allocateSlot(int index, JobID jobId, AllocationID allocationId, Time slotTimeout) {
        return this.callAsync(() -> this.taskSlotTable.allocateSlot(index, jobId, allocationId, slotTimeout));
    }

    public boolean allocateSlot(int index, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, Time slotTimeout) {
        return this.callAsync(() -> this.taskSlotTable.allocateSlot(index, jobId, allocationId, resourceProfile, slotTimeout));
    }

    public boolean markSlotActive(AllocationID allocationId) throws SlotNotFoundException {
        return this.callAsync(() -> this.taskSlotTable.markSlotActive(allocationId));
    }

    public boolean markSlotInactive(AllocationID allocationId, Time slotTimeout) throws SlotNotFoundException {
        return this.callAsync(() -> this.taskSlotTable.markSlotInactive(allocationId, slotTimeout));
    }

    public int freeSlot(AllocationID allocationId) throws SlotNotFoundException {
        return this.callAsync(() -> this.taskSlotTable.freeSlot(allocationId));
    }

    public int freeSlot(AllocationID allocationId, Throwable cause) throws SlotNotFoundException {
        return this.callAsync(() -> this.taskSlotTable.freeSlot(allocationId, cause));
    }

    public boolean isValidTimeout(AllocationID allocationId, UUID ticket) {
        return this.callAsync(() -> this.taskSlotTable.isValidTimeout(allocationId, ticket));
    }

    public boolean isAllocated(int index, JobID jobId, AllocationID allocationId) {
        return this.callAsync(() -> this.taskSlotTable.isAllocated(index, jobId, allocationId));
    }

    public boolean tryMarkSlotActive(JobID jobId, AllocationID allocationId) {
        return this.callAsync(() -> this.taskSlotTable.tryMarkSlotActive(jobId, allocationId));
    }

    public boolean isSlotFree(int index) {
        return this.callAsync(() -> this.taskSlotTable.isSlotFree(index));
    }

    public boolean hasAllocatedSlots(JobID jobId) {
        return this.callAsync(() -> this.taskSlotTable.hasAllocatedSlots(jobId));
    }

    public Iterator<TaskSlot<T>> getAllocatedSlots(JobID jobId) {
        return this.callAsync(() -> this.taskSlotTable.getAllocatedSlots(jobId));
    }

    @Nullable
    public JobID getOwningJob(AllocationID allocationId) {
        return this.callAsync(() -> this.taskSlotTable.getOwningJob(allocationId));
    }

    public boolean addTask(T task) throws SlotNotFoundException, SlotNotActiveException {
        return this.callAsync(() -> this.taskSlotTable.addTask(task));
    }

    public T removeTask(ExecutionAttemptID executionAttemptID) {
        return (T)this.callAsync(() -> this.taskSlotTable.removeTask(executionAttemptID));
    }

    public T getTask(ExecutionAttemptID executionAttemptID) {
        return (T)this.callAsync(() -> this.taskSlotTable.getTask(executionAttemptID));
    }

    public Iterator<T> getTasks(JobID jobId) {
        return this.callAsync(() -> this.taskSlotTable.getTasks(jobId));
    }

    public AllocationID getCurrentAllocation(int index) {
        return this.callAsync(() -> this.taskSlotTable.getCurrentAllocation(index));
    }

    public MemoryManager getTaskMemoryManager(AllocationID allocationID) throws SlotNotFoundException {
        return this.callAsync(() -> this.taskSlotTable.getTaskMemoryManager(allocationID));
    }

    public void notifyTimeout(AllocationID key, UUID ticket) {
        this.runAsync(() -> this.taskSlotTable.notifyTimeout((Object)key, ticket));
    }

    public CompletableFuture<Void> closeAsync() {
        return this.callAsync(() -> this.taskSlotTable.closeAsync());
    }

    public void close() throws Exception {
        this.callAsync(() -> {
            this.taskSlotTable.close();
            return null;
        });
    }
}

