/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.runtime.taskexecutor.DefaultShuffleDescriptorsCache;
import org.apache.flink.shaded.guava31.com.google.common.base.Ticker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultShuffleDescriptorsCacheTest {
    private final Duration expireTimeout = Duration.ofSeconds(10L);

    DefaultShuffleDescriptorsCacheTest() {
    }

    @Test
    void testGetEntry() {
        DefaultShuffleDescriptorsCache cache = new DefaultShuffleDescriptorsCache.Factory(this.expireTimeout, Integer.MAX_VALUE, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        Assertions.assertThat((Object)cache.get(blobKey)).isNull();
        cache.put(jobId, blobKey, shuffleDescriptorGroup);
        Assertions.assertThat((Object)cache.get(blobKey)).isEqualTo((Object)shuffleDescriptorGroup);
    }

    @Test
    void testClearCacheForJob() {
        DefaultShuffleDescriptorsCache cache = new DefaultShuffleDescriptorsCache.Factory(this.expireTimeout, Integer.MAX_VALUE, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        Assertions.assertThat((Object)cache.get(blobKey)).isNull();
        cache.put(jobId, blobKey, shuffleDescriptorGroup);
        Assertions.assertThat((Object)cache.get(blobKey)).isEqualTo((Object)shuffleDescriptorGroup);
        cache.clearCacheForJob(jobId);
        Assertions.assertThat((Object)cache.get(blobKey)).isNull();
    }

    @Test
    void testPutWhenOverLimit() {
        DefaultShuffleDescriptorsCache cache = new DefaultShuffleDescriptorsCache.Factory(this.expireTimeout, 1, Ticker.systemTicker()).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        cache.put(jobId, blobKey, shuffleDescriptorGroup);
        Assertions.assertThat((Object)cache.get(blobKey)).isEqualTo((Object)shuffleDescriptorGroup);
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup otherShuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)new UnknownShuffleDescriptor(new ResultPartitionID()), 0)});
        PermanentBlobKey otherBlobKey = new PermanentBlobKey();
        cache.put(jobId, otherBlobKey, otherShuffleDescriptorGroup);
        Assertions.assertThat((Object)cache.get(blobKey)).isNull();
        Assertions.assertThat((Object)cache.get(otherBlobKey)).isEqualTo((Object)otherShuffleDescriptorGroup);
    }

    @Test
    void testEntryExpired() {
        TestingTicker ticker = new TestingTicker();
        DefaultShuffleDescriptorsCache cache = new DefaultShuffleDescriptorsCache.Factory(Duration.ofSeconds(1L), Integer.MAX_VALUE, (Ticker)ticker).create();
        JobID jobId = new JobID();
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(new ResultPartitionID());
        TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup shuffleDescriptorGroup = new TaskDeploymentDescriptorFactory.ShuffleDescriptorGroup(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]{new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex((ShuffleDescriptor)shuffleDescriptor, 0)});
        PermanentBlobKey blobKey = new PermanentBlobKey();
        cache.put(jobId, blobKey, shuffleDescriptorGroup);
        Assertions.assertThat((Object)cache.get(blobKey)).isEqualTo((Object)shuffleDescriptorGroup);
        ticker.advance(Duration.ofSeconds(2L));
        Assertions.assertThat((Object)cache.get(blobKey)).isNull();
    }

    private static class TestingTicker
    extends Ticker {
        private final AtomicLong nanos = new AtomicLong();

        private TestingTicker() {
        }

        public void advance(Duration duration) {
            this.nanos.addAndGet(duration.toNanos());
        }

        public long read() {
            return this.nanos.get();
        }
    }
}

