/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import org.apache.flink.runtime.state.DirectoryStateHandle;
import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SnapshotDirectoryTest
extends TestLogger {
    private static TemporaryFolder temporaryFolder;

    @BeforeClass
    public static void beforeClass() throws IOException {
        temporaryFolder = new TemporaryFolder();
        temporaryFolder.create();
    }

    @AfterClass
    public static void afterClass() {
        temporaryFolder.delete();
    }

    @Test
    public void mkdirs() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File newFolder = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File innerNewFolder = new File(newFolder, String.valueOf(UUID.randomUUID()));
        Path path = innerNewFolder.toPath();
        Assert.assertFalse((boolean)newFolder.isDirectory());
        Assert.assertFalse((boolean)innerNewFolder.isDirectory());
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assert.assertFalse((boolean)snapshotDirectory.exists());
        Assert.assertFalse((boolean)newFolder.isDirectory());
        Assert.assertFalse((boolean)innerNewFolder.isDirectory());
        Assert.assertTrue((boolean)snapshotDirectory.mkdirs());
        Assert.assertTrue((boolean)newFolder.isDirectory());
        Assert.assertTrue((boolean)innerNewFolder.isDirectory());
        Assert.assertTrue((boolean)snapshotDirectory.exists());
    }

    @Test
    public void exists() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assert.assertFalse((boolean)folderA.isDirectory());
        Path path = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assert.assertFalse((boolean)snapshotDirectory.exists());
        Assert.assertTrue((boolean)folderA.mkdirs());
        Assert.assertTrue((boolean)snapshotDirectory.exists());
        Assert.assertTrue((boolean)folderA.delete());
        Assert.assertFalse((boolean)snapshotDirectory.exists());
    }

    @Test
    public void listStatus() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File folderB = new File(folderA, String.valueOf(UUID.randomUUID()));
        Assert.assertTrue((boolean)folderB.mkdirs());
        File file = new File(folderA, "test.txt");
        Assert.assertTrue((boolean)file.createNewFile());
        Path path = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)path);
        Assert.assertTrue((boolean)snapshotDirectory.exists());
        Assert.assertEquals((Object)Arrays.toString(FileUtils.listDirectory((Path)path)), (Object)Arrays.toString(snapshotDirectory.listDirectory()));
    }

    @Test
    public void completeSnapshotAndGetHandle() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assert.assertTrue((boolean)folderA.mkdirs());
        Path folderAPath = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        DirectoryStateHandle handle = snapshotDirectory.completeSnapshotAndGetHandle();
        Assert.assertNotNull((Object)handle);
        Assert.assertTrue((boolean)snapshotDirectory.cleanup());
        Assert.assertTrue((boolean)folderA.isDirectory());
        Assert.assertEquals((Object)folderAPath, (Object)handle.getDirectory());
        handle.discardState();
        Assert.assertFalse((boolean)folderA.isDirectory());
        Assert.assertTrue((boolean)folderA.mkdirs());
        snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        Assert.assertTrue((boolean)snapshotDirectory.cleanup());
        try {
            snapshotDirectory.completeSnapshotAndGetHandle();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void deleteIfNotCompeltedSnapshot() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        File folderB = new File(folderA, String.valueOf(UUID.randomUUID()));
        Assert.assertTrue((boolean)folderB.mkdirs());
        File file = new File(folderA, "test.txt");
        Assert.assertTrue((boolean)file.createNewFile());
        Path folderAPath = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        Assert.assertTrue((boolean)snapshotDirectory.cleanup());
        Assert.assertFalse((boolean)folderA.isDirectory());
        Assert.assertTrue((boolean)folderA.mkdirs());
        Assert.assertTrue((boolean)file.createNewFile());
        snapshotDirectory = SnapshotDirectory.permanent((Path)folderAPath);
        snapshotDirectory.completeSnapshotAndGetHandle();
        Assert.assertTrue((boolean)snapshotDirectory.cleanup());
        Assert.assertTrue((boolean)folderA.isDirectory());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test
    public void isSnapshotOngoing() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folderA = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assert.assertTrue((boolean)folderA.mkdirs());
        Path pathA = folderA.toPath();
        SnapshotDirectory snapshotDirectory = SnapshotDirectory.permanent((Path)pathA);
        Assert.assertFalse((boolean)snapshotDirectory.isSnapshotCompleted());
        Assert.assertNotNull((Object)snapshotDirectory.completeSnapshotAndGetHandle());
        Assert.assertTrue((boolean)snapshotDirectory.isSnapshotCompleted());
        snapshotDirectory = SnapshotDirectory.permanent((Path)pathA);
        Assert.assertFalse((boolean)snapshotDirectory.isSnapshotCompleted());
        snapshotDirectory.cleanup();
        Assert.assertFalse((boolean)snapshotDirectory.isSnapshotCompleted());
    }

    @Test
    public void temporary() throws Exception {
        File folderRoot = temporaryFolder.getRoot();
        File folder = new File(folderRoot, String.valueOf(UUID.randomUUID()));
        Assert.assertTrue((boolean)folder.mkdirs());
        SnapshotDirectory tmpSnapshotDirectory = SnapshotDirectory.temporary((File)folder);
        Assert.assertNull((Object)tmpSnapshotDirectory.completeSnapshotAndGetHandle());
        Assert.assertTrue((boolean)tmpSnapshotDirectory.cleanup());
        Assert.assertFalse((boolean)folder.exists());
    }
}

