/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.exceptionhistory.ArchivedTaskManagerLocationMatcher;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionHistoryEntryTest
extends TestLogger {
    @Test
    public void testCreate() {
        RuntimeException failure = new RuntimeException("Expected exception");
        long timestamp = System.currentTimeMillis();
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        TestingAccessExecution execution = TestingAccessExecution.newBuilder().withErrorInfo(new ErrorInfo((Throwable)failure, timestamp)).withTaskManagerLocation(taskManagerLocation).build();
        String taskName = "task name";
        Map<String, String> failureLabels = Collections.singletonMap("key", "value");
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)execution, (String)"task name", CompletableFuture.completedFuture(failureLabels));
        Assert.assertThat((Object)entry.getException().deserializeError(ClassLoader.getSystemClassLoader()), (Matcher)CoreMatchers.is((Object)failure));
        Assert.assertThat((Object)entry.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertThat((Object)entry.getFailingTaskName(), (Matcher)CoreMatchers.is((Object)"task name"));
        Assert.assertThat((Object)entry.getTaskManagerLocation(), ArchivedTaskManagerLocationMatcher.isArchivedTaskManagerLocation(taskManagerLocation));
        Assert.assertThat((Object)entry.isGlobal(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)entry.getFailureLabels(), (Matcher)CoreMatchers.is(failureLabels));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreationFailure() {
        ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withTaskManagerLocation(new LocalTaskManagerLocation()).build(), (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullExecution() {
        ExceptionHistoryEntry.create(null, (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS);
    }

    @Test(expected=NullPointerException.class)
    public void testNullTaskName() {
        ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withErrorInfo(new ErrorInfo((Throwable)new Exception("Expected failure"), System.currentTimeMillis())).withTaskManagerLocation(new LocalTaskManagerLocation()).build(), null, (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS);
    }

    @Test
    public void testWithMissingTaskManagerLocation() {
        Exception failure = new Exception("Expected failure");
        long timestamp = System.currentTimeMillis();
        String taskName = "task name";
        ExceptionHistoryEntry entry = ExceptionHistoryEntry.create((AccessExecution)TestingAccessExecution.newBuilder().withTaskManagerLocation(null).withErrorInfo(new ErrorInfo((Throwable)failure, timestamp)).build(), (String)"task name", (CompletableFuture)FailureEnricherUtils.EMPTY_FAILURE_LABELS);
        Assert.assertThat((Object)entry.getException().deserializeError(ClassLoader.getSystemClassLoader()), (Matcher)CoreMatchers.is((Object)failure));
        Assert.assertThat((Object)entry.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertThat((Object)entry.getFailingTaskName(), (Matcher)CoreMatchers.is((Object)"task name"));
        Assert.assertThat((Object)entry.getTaskManagerLocation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)entry.isGlobal(), (Matcher)CoreMatchers.is((Object)false));
    }
}

