/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;

class TestVertexInformation
implements JobInformation.VertexInformation {
    private final JobVertexID jobVertexId;
    private final int minParallelism;
    private final int parallelism;
    private final SlotSharingGroup slotSharingGroup;

    TestVertexInformation(JobVertexID jobVertexId, int parallelism, SlotSharingGroup slotSharingGroup) {
        this(jobVertexId, 1, parallelism, slotSharingGroup);
    }

    TestVertexInformation(JobVertexID jobVertexId, int minParallelism, int parallelism, SlotSharingGroup slotSharingGroup) {
        this.jobVertexId = jobVertexId;
        this.minParallelism = minParallelism;
        this.parallelism = parallelism;
        this.slotSharingGroup = slotSharingGroup;
        slotSharingGroup.addVertexToGroup(jobVertexId);
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexId;
    }

    public int getMinParallelism() {
        return this.minParallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return 128;
    }

    public SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }
}

