/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.dataset;

import java.util.HashMap;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.DataSetMetaInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetEntry;
import org.apache.flink.runtime.rest.messages.dataset.ClusterDataSetListResponseBody;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class ClusterDataSetListResponseBodyTest
extends RestResponseMarshallingTestBase<ClusterDataSetListResponseBody> {
    @Test
    public void testFrom() {
        HashMap<IntermediateDataSetID, DataSetMetaInfo> originalDataSets = new HashMap<IntermediateDataSetID, DataSetMetaInfo>();
        originalDataSets.put(new IntermediateDataSetID(), DataSetMetaInfo.withNumRegisteredPartitions((int)1, (int)2));
        originalDataSets.put(new IntermediateDataSetID(), DataSetMetaInfo.withNumRegisteredPartitions((int)2, (int)2));
        List convertedDataSets = ClusterDataSetListResponseBody.from(originalDataSets).getDataSets();
        MatcherAssert.assertThat((Object)convertedDataSets, (Matcher)Matchers.hasSize((int)2));
        for (ClusterDataSetEntry convertedDataSet : convertedDataSets) {
            IntermediateDataSetID id = new IntermediateDataSetID(new AbstractID(StringUtils.hexStringToByte((String)convertedDataSet.getDataSetId())));
            DataSetMetaInfo dataSetMetaInfo = (DataSetMetaInfo)originalDataSets.get(id);
            MatcherAssert.assertThat((Object)convertedDataSet.isComplete(), (Matcher)Matchers.is((Object)(dataSetMetaInfo.getNumRegisteredPartitions().orElse(0) == dataSetMetaInfo.getNumTotalPartitions() ? 1 : 0)));
        }
    }

    @Override
    protected Class<ClusterDataSetListResponseBody> getTestResponseClass() {
        return ClusterDataSetListResponseBody.class;
    }

    @Override
    protected ClusterDataSetListResponseBody getTestResponseInstance() throws Exception {
        HashMap<IntermediateDataSetID, DataSetMetaInfo> dataSets = new HashMap<IntermediateDataSetID, DataSetMetaInfo>();
        dataSets.put(new IntermediateDataSetID(), DataSetMetaInfo.withNumRegisteredPartitions((int)1, (int)2));
        return ClusterDataSetListResponseBody.from(dataSets);
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(ClusterDataSetListResponseBody expected, ClusterDataSetListResponseBody actual) {
        List expectedDataSets = expected.getDataSets();
        List actualDataSets = actual.getDataSets();
        MatcherAssert.assertThat((Object)actualDataSets, (Matcher)Matchers.hasSize((int)expectedDataSets.size()));
        for (int i = 0; i < expectedDataSets.size(); ++i) {
            ClusterDataSetEntry expectedDataSet = (ClusterDataSetEntry)expectedDataSets.get(i);
            ClusterDataSetEntry actualDataSet = (ClusterDataSetEntry)actualDataSets.get(i);
            MatcherAssert.assertThat((Object)actualDataSet.getDataSetId(), (Matcher)Matchers.is((Object)expectedDataSet.getDataSetId()));
            MatcherAssert.assertThat((Object)actualDataSet.isComplete(), (Matcher)Matchers.is((Object)expectedDataSet.isComplete()));
        }
    }
}

