/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ThreadDumpInfoTest
extends RestResponseMarshallingTestBase<ThreadDumpInfo> {
    @Override
    protected Class<ThreadDumpInfo> getTestResponseClass() {
        return ThreadDumpInfo.class;
    }

    @Override
    protected ThreadDumpInfo getTestResponseInstance() throws Exception {
        List<ThreadDumpInfo.ThreadInfo> threadInfos = Arrays.asList(ThreadDumpInfo.ThreadInfo.create((String)"foobar", (String)"barfoo"), ThreadDumpInfo.ThreadInfo.create((String)"bar", (String)"foo"));
        return ThreadDumpInfo.create(threadInfos);
    }

    @Override
    protected void assertOriginalEqualsToUnmarshalled(ThreadDumpInfo expected, ThreadDumpInfo actual) {
        Assert.assertThat((Object)actual.getThreadInfos(), (Matcher)Matchers.containsInAnyOrder((Object[])expected.getThreadInfos().toArray()));
    }

    @Test
    public void testComparedWithDefaultJDKImplemetation() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMxBean.getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
        String[] threadInfoLines = threadInfo.toString().split("\n");
        Object[] expected = Arrays.copyOfRange(threadInfoLines, 1, threadInfoLines.length);
        String stringifyThreadInfo = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)8);
        String[] stringifyThreadInfoLines = stringifyThreadInfo.split("\n");
        Object[] stringified = Arrays.copyOfRange(stringifyThreadInfoLines, 1, stringifyThreadInfoLines.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])stringified);
    }

    @Test
    public void testStacktraceDepthLimitation() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo threadInfo = threadMxBean.getThreadInfo(Thread.currentThread().getId(), Integer.MAX_VALUE);
        int expectedStacktraceDepth = threadInfo.getStackTrace().length;
        String stringifiedInfo = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)expectedStacktraceDepth, (long)this.getOutputDepth(stringifiedInfo));
        String stringifiedInfoExceedMaxDepth = ThreadDumpInfo.stringifyThreadInfo((ThreadInfo)threadInfo, (int)(expectedStacktraceDepth - 1));
        Assert.assertEquals((long)(expectedStacktraceDepth - 1), (long)this.getOutputDepth(stringifiedInfoExceedMaxDepth));
        Assert.assertTrue((boolean)stringifiedInfoExceedMaxDepth.contains("\t..."));
    }

    private long getOutputDepth(String stringifiedInfo) {
        return Arrays.stream(stringifiedInfo.split("\n")).filter(x -> x.contains("\tat ")).count();
    }
}

