/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.dump.TestingMetricQueryServiceGateway;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class MetricFetcherTest {
    MetricFetcherTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testUpdate() {
        MetricStore store;
        Time timeout = Time.seconds((long)10L);
        JobID jobID = new JobID();
        ResourceID tmRID = ResourceID.generate();
        MetricFetcher fetcher = this.createMetricFetcherWithServiceGateways(jobID, tmRID, timeout, (Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue(), 0L, null);
        fetcher.update();
        MetricStore metricStore = store = fetcher.getMetricStore();
        synchronized (metricStore) {
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_min")).isEqualTo("7");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_max")).isEqualTo("6");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_mean")).isEqualTo("4.0");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_median")).isEqualTo("0.5");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_stddev")).isEqualTo("5.0");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p75")).isEqualTo("0.75");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p90")).isEqualTo("0.9");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p95")).isEqualTo("0.95");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p98")).isEqualTo("0.98");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p99")).isEqualTo("0.99");
            Assertions.assertThat((String)store.getJobManagerMetricStore().getMetric("abc.hist_p999")).isEqualTo("0.999");
            Assertions.assertThat((String)((String)store.getTaskManagerMetricStore((String)tmRID.toString()).metrics.get("abc.gauge"))).isEqualTo("x");
            Assertions.assertThat((String)((String)store.getJobMetricStore((String)jobID.toString()).metrics.get("abc.jc"))).isEqualTo("5.0");
            Assertions.assertThat((String)((String)store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.abc.tc"))).isEqualTo("2");
            Assertions.assertThat((String)((String)store.getTaskMetricStore((String)jobID.toString(), (String)"taskid").metrics.get("2.opname.abc.oc"))).isEqualTo("1");
            Assertions.assertThat((String)store.getTaskMetricStore(jobID.toString(), "taskid").getJobManagerOperatorMetricStores("opname").getMetric("abc.joc")).isEqualTo("3");
        }
    }

    private static MetricDumpSerialization.MetricSerializationResult createRequestDumpAnswer(ResourceID tmRID, JobID jobID) {
        HashMap<SimpleCounter, Tuple2> counters = new HashMap<SimpleCounter, Tuple2>();
        HashMap<2, Tuple2> gauges = new HashMap<2, Tuple2>();
        HashMap<TestHistogram, Tuple2> histograms = new HashMap<TestHistogram, Tuple2>();
        HashMap<1, Tuple2> meters = new HashMap<1, Tuple2>();
        SimpleCounter c1 = new SimpleCounter();
        SimpleCounter c2 = new SimpleCounter();
        SimpleCounter c3 = new SimpleCounter();
        c1.inc(1L);
        c2.inc(2L);
        c3.inc(3L);
        counters.put(c1, new Tuple2((Object)new QueryScopeInfo.OperatorQueryScopeInfo(jobID.toString(), "taskid", 2, 0, "opname", "abc"), (Object)"oc"));
        counters.put(c2, new Tuple2((Object)new QueryScopeInfo.TaskQueryScopeInfo(jobID.toString(), "taskid", 2, 0, "abc"), (Object)"tc"));
        counters.put(c3, new Tuple2((Object)new QueryScopeInfo.JobManagerOperatorQueryScopeInfo(jobID.toString(), "taskid", "opname", "abc"), (Object)"joc"));
        meters.put(new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        }, new Tuple2((Object)new QueryScopeInfo.JobQueryScopeInfo(jobID.toString(), "abc"), (Object)"jc"));
        gauges.put(new Gauge<String>(){

            public String getValue() {
                return "x";
            }
        }, new Tuple2((Object)new QueryScopeInfo.TaskManagerQueryScopeInfo(tmRID.toString(), "abc"), (Object)"gauge"));
        histograms.put(new TestHistogram(), new Tuple2((Object)new QueryScopeInfo.JobManagerQueryScopeInfo("abc"), (Object)"hist"));
        MetricDumpSerialization.MetricDumpSerializer serializer = new MetricDumpSerialization.MetricDumpSerializer();
        MetricDumpSerialization.MetricSerializationResult dump = serializer.serialize(counters, gauges, histograms, meters);
        serializer.close();
        return dump;
    }

    @Test
    void testLongUpdateInterval() {
        long updateInterval = 1000L;
        AtomicInteger requestMetricQueryServiceGatewaysCounter = new AtomicInteger(0);
        RestfulGateway restfulGateway = this.createRestfulGateway(requestMetricQueryServiceGatewaysCounter);
        MetricFetcher fetcher = this.createMetricFetcher(1000L, restfulGateway);
        fetcher.update();
        fetcher.update();
        Assertions.assertThat((AtomicInteger)requestMetricQueryServiceGatewaysCounter).hasValue(1);
    }

    @Test
    void testShortUpdateInterval() throws InterruptedException {
        long updateInterval = 1L;
        AtomicInteger requestMetricQueryServiceGatewaysCounter = new AtomicInteger(0);
        RestfulGateway restfulGateway = this.createRestfulGateway(requestMetricQueryServiceGatewaysCounter);
        MetricFetcher fetcher = this.createMetricFetcher(1L, restfulGateway);
        fetcher.update();
        long start = System.currentTimeMillis();
        long difference = 0L;
        while (difference <= 1L) {
            Thread.sleep(2L);
            difference = System.currentTimeMillis() - start;
        }
        fetcher.update();
        Assertions.assertThat((AtomicInteger)requestMetricQueryServiceGatewaysCounter).hasValue(2);
    }

    @Test
    void testIgnoreUpdateRequestWhenFetchingMetrics() throws InterruptedException {
        long updateInterval = 1000L;
        long waitTimeBeforeReturnMetricResults = 2000L;
        Time timeout = Time.seconds((long)10L);
        AtomicInteger requestMetricQueryServiceGatewaysCounter = new AtomicInteger(0);
        JobID jobID = new JobID();
        ResourceID tmRID = ResourceID.generate();
        MetricFetcher fetcher = this.createMetricFetcherWithServiceGateways(jobID, tmRID, timeout, 1000L, 2000L, requestMetricQueryServiceGatewaysCounter);
        fetcher.update();
        long start = System.currentTimeMillis();
        long difference = 0L;
        while (difference <= 1000L) {
            Thread.sleep(1500L);
            difference = System.currentTimeMillis() - start;
        }
        fetcher.update();
        Assertions.assertThat((AtomicInteger)requestMetricQueryServiceGatewaysCounter).hasValue(1);
    }

    private MetricFetcher createMetricFetcherWithServiceGateways(JobID jobID, ResourceID tmRID, Time timeout, long updateInterval, long waitTimeBeforeReturnMetricResults, @Nullable AtomicInteger requestMetricQueryServiceGatewaysCounter) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        TestingMetricQueryServiceGateway jmQueryService = new TestingMetricQueryServiceGateway.Builder().setQueryMetricsSupplier(() -> CompletableFuture.completedFuture(new MetricDumpSerialization.MetricSerializationResult(new byte[0], new byte[0], new byte[0], new byte[0], 0, 0, 0, 0))).build();
        MetricDumpSerialization.MetricSerializationResult requestMetricsAnswer = MetricFetcherTest.createRequestDumpAnswer(tmRID, jobID);
        TestingMetricQueryServiceGateway tmQueryService = new TestingMetricQueryServiceGateway.Builder().setQueryMetricsSupplier(() -> {
            if (waitTimeBeforeReturnMetricResults > 0L) {
                CompletableFuture metricsAnswerFuture = new CompletableFuture();
                FutureUtils.completedVoidFuture().thenComposeAsync(ignored -> {
                    try {
                        Thread.sleep(waitTimeBeforeReturnMetricResults);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    metricsAnswerFuture.complete(requestMetricsAnswer);
                    return metricsAnswerFuture;
                }, (Executor)executor);
                return metricsAnswerFuture;
            }
            return CompletableFuture.completedFuture(requestMetricsAnswer);
        }).build();
        TestingRestfulGateway restfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestMultipleJobDetailsSupplier(() -> CompletableFuture.completedFuture(new MultipleJobsDetails(Collections.emptyList())))).setRequestMetricQueryServiceGatewaysSupplier(() -> {
            if (requestMetricQueryServiceGatewaysCounter != null) {
                requestMetricQueryServiceGatewaysCounter.incrementAndGet();
            }
            return CompletableFuture.completedFuture(Collections.singleton(jmQueryService.getAddress()));
        })).setRequestTaskManagerMetricQueryServiceGatewaysSupplier(() -> CompletableFuture.completedFuture(Collections.singleton(Tuple2.of((Object)tmRID, (Object)tmQueryService.getAddress()))))).build();
        GatewayRetriever retriever = () -> CompletableFuture.completedFuture(restfulGateway);
        return new MetricFetcherImpl(retriever, address -> CompletableFuture.completedFuture(tmQueryService), org.apache.flink.util.concurrent.Executors.directExecutor(), timeout, updateInterval);
    }

    private MetricFetcher createMetricFetcher(long updateInterval, RestfulGateway restfulGateway) {
        return new MetricFetcherImpl(() -> CompletableFuture.completedFuture(restfulGateway), address -> null, org.apache.flink.util.concurrent.Executors.directExecutor(), Time.seconds((long)10L), updateInterval);
    }

    private RestfulGateway createRestfulGateway(AtomicInteger requestMetricQueryServiceGatewaysCounter) {
        return ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestMetricQueryServiceGatewaysSupplier(() -> {
            requestMetricQueryServiceGatewaysCounter.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        })).build();
    }
}

