/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointStatsCacheTest {
    @Test
    public void testZeroSizeCache() throws Exception {
        AbstractCheckpointStats checkpoint = this.createCheckpoint(0L, CheckpointStatsStatus.COMPLETED);
        CheckpointStatsCache cache = new CheckpointStatsCache(0);
        cache.tryAdd(checkpoint);
        Assert.assertNull((Object)cache.tryGet(0L));
    }

    @Test
    public void testCacheAddAndGet() throws Exception {
        AbstractCheckpointStats chk0 = this.createCheckpoint(0L, CheckpointStatsStatus.COMPLETED);
        AbstractCheckpointStats chk1 = this.createCheckpoint(1L, CheckpointStatsStatus.COMPLETED);
        AbstractCheckpointStats chk2 = this.createCheckpoint(2L, CheckpointStatsStatus.IN_PROGRESS);
        CheckpointStatsCache cache = new CheckpointStatsCache(1);
        cache.tryAdd(chk0);
        Assert.assertEquals((Object)chk0, (Object)cache.tryGet(0L));
        cache.tryAdd(chk1);
        Assert.assertNull((Object)cache.tryGet(0L));
        Assert.assertEquals((Object)chk1, (Object)cache.tryGet(1L));
        cache.tryAdd(chk2);
        Assert.assertNull((Object)cache.tryGet(2L));
        Assert.assertNull((Object)cache.tryGet(0L));
        Assert.assertEquals((Object)chk1, (Object)cache.tryGet(1L));
    }

    private AbstractCheckpointStats createCheckpoint(long id, CheckpointStatsStatus status) {
        AbstractCheckpointStats checkpoint = (AbstractCheckpointStats)Mockito.mock(AbstractCheckpointStats.class);
        Mockito.when((Object)checkpoint.getCheckpointId()).thenReturn((Object)id);
        Mockito.when((Object)checkpoint.getStatus()).thenReturn((Object)status);
        return checkpoint;
    }
}

