/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.async.OperationResultStatus;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.shaded.guava31.com.google.common.base.Ticker;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompletedOperationCacheTest
extends TestLogger {
    private static final OperationKey TEST_OPERATION_KEY = new OperationKey(new TriggerId());
    private static final CompletableFuture<String> TEST_OPERATION_RESULT = CompletableFuture.completedFuture("foo");
    private ManualTicker manualTicker;
    private CompletedOperationCache<OperationKey, String> completedOperationCache;

    @Before
    public void setUp() {
        this.manualTicker = new ManualTicker();
        this.completedOperationCache = new CompletedOperationCache((Ticker)this.manualTicker);
    }

    @Test
    public void testShouldFinishClosingCacheIfAllResultsAreEvicted() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)false));
        this.manualTicker.advanceTime(300L, TimeUnit.SECONDS);
        this.completedOperationCache.cleanUp();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testShouldFinishClosingCacheIfAllResultsAccessed() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)false));
        Optional operationResultOptional = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assert.assertTrue((boolean)operationResultOptional.isPresent());
        OperationResult operationResult = (OperationResult)operationResultOptional.get();
        Assert.assertEquals((Object)operationResult.getStatus(), (Object)OperationResultStatus.SUCCESS);
        Assert.assertThat((Object)operationResult.getResult(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_OPERATION_RESULT.get())));
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCannotAddOperationAfterClosing() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, new CompletableFuture());
        CompletableFuture terminationFuture = this.completedOperationCache.closeAsync();
        Assert.assertFalse((boolean)terminationFuture.isDone());
        try {
            this.completedOperationCache.registerOngoingOperation(new OperationKey(new TriggerId()), new CompletableFuture());
            Assert.fail((String)"It should no longer be possible to register new operations because the cache is shutting down.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCanGetOperationResultAfterClosing() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.completedOperationCache.closeAsync();
        Optional operationResultOptional = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assert.assertTrue((boolean)operationResultOptional.isPresent());
        OperationResult operationResult = (OperationResult)operationResultOptional.get();
        Assert.assertEquals((Object)operationResult.getStatus(), (Object)OperationResultStatus.SUCCESS);
        Assert.assertThat((Object)operationResult.getResult(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_OPERATION_RESULT.get())));
    }

    @Test
    public void testCacheTimeout() throws Exception {
        Duration timeout = (Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue();
        this.completedOperationCache = new CompletedOperationCache(timeout, (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        Assert.assertTrue((boolean)this.completedOperationCache.get(TEST_OPERATION_KEY).isPresent());
        this.manualTicker.advanceTime(timeout.multipliedBy(2L).getSeconds(), TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.completedOperationCache.get(TEST_OPERATION_KEY).isPresent());
    }

    @Test
    public void testCacheTimeoutCanBeDisabled() throws Exception {
        this.completedOperationCache = new CompletedOperationCache(Duration.ofSeconds(0L), (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.manualTicker.advanceTime(365L, TimeUnit.DAYS);
        Assert.assertTrue((boolean)this.completedOperationCache.get(TEST_OPERATION_KEY).isPresent());
    }

    @Test
    public void testCacheTimeoutCanBeConfigured() throws Exception {
        Duration baseTimeout = (Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue();
        this.completedOperationCache = new CompletedOperationCache(baseTimeout.multipliedBy(10L), (Ticker)this.manualTicker);
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.manualTicker.advanceTime(baseTimeout.multipliedBy(2L).getSeconds(), TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.completedOperationCache.get(TEST_OPERATION_KEY).isPresent());
    }

    @Test
    public void containsReturnsFalseForUnknownOperation() {
        Assert.assertThat((Object)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void containsChecksOnoingOperations() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, new CompletableFuture());
        Assert.assertThat((Object)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void containsChecksCompletedOperations() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, CompletableFuture.completedFuture(null));
        Assert.assertThat((Object)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void containsDoesNotMarkResultAsAccessed() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, CompletableFuture.completedFuture(null));
        Assert.assertThat((Object)this.completedOperationCache.containsOperation(TEST_OPERATION_KEY), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.completedOperationCache.closeAsync(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(10L)));
    }
}

