/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingLeaderElection;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.ResourceManagerService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerServiceImpl;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManagerFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.security.token.NoOpDelegationTokenManager;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingResourceManagerService
implements ResourceManagerService {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private final ResourceManagerServiceImpl rmService;
    private final TestingLeaderElection leaderElection;
    private final TestingFatalErrorHandler fatalErrorHandler;
    private final RpcService rpcService;
    private final boolean needStopRpcService;

    private TestingResourceManagerService(ResourceManagerServiceImpl rmService, TestingLeaderElection leaderElection, TestingFatalErrorHandler fatalErrorHandler, RpcService rpcService, boolean needStopRpcService) {
        this.rmService = rmService;
        this.leaderElection = leaderElection;
        this.fatalErrorHandler = fatalErrorHandler;
        this.rpcService = rpcService;
        this.needStopRpcService = needStopRpcService;
    }

    public void start() throws Exception {
        this.rmService.start();
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.rmService.getTerminationFuture();
    }

    public CompletableFuture<Void> deregisterApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        return this.rmService.deregisterApplication(applicationStatus, diagnostics);
    }

    public CompletableFuture<Void> closeAsync() {
        return this.rmService.closeAsync();
    }

    public Optional<ResourceManagerGateway> getResourceManagerGateway() {
        return this.getResourceManagerOpt().map(rm -> (ResourceManagerGateway)rm.getSelfGateway(ResourceManagerGateway.class));
    }

    public Optional<ResourceManagerId> getResourceManagerFencingToken() {
        return this.getResourceManagerOpt().map(FencedRpcEndpoint::getFencingToken);
    }

    public Optional<CompletableFuture<Void>> getResourceManagerTerminationFuture() {
        return this.getResourceManagerOpt().map(RpcEndpoint::getTerminationFuture);
    }

    private Optional<ResourceManager<?>> getResourceManagerOpt() {
        return Optional.ofNullable(this.rmService.getLeaderResourceManager());
    }

    public CompletableFuture<LeaderInformation> isLeader(UUID uuid) {
        return this.leaderElection.isLeader(uuid);
    }

    public void notLeader() {
        this.leaderElection.notLeader();
    }

    public void rethrowFatalErrorIfAny() throws Exception {
        if (this.fatalErrorHandler.hasExceptionOccurred()) {
            this.fatalErrorHandler.rethrowError();
        }
    }

    public void ignoreFatalErrors() {
        this.fatalErrorHandler.clearError();
    }

    public void cleanUp() throws Exception {
        ((CompletableFuture)this.rmService.closeAsync().thenCompose(ignore -> this.stopRpcServiceIfNeeded())).get(TIMEOUT.getSize(), TIMEOUT.getUnit());
    }

    private CompletableFuture<Void> stopRpcServiceIfNeeded() {
        return this.needStopRpcService ? this.rpcService.closeAsync() : FutureUtils.completedVoidFuture();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private RpcService rpcService = null;
        private boolean needStopRpcService = true;
        private TestingLeaderElection rmLeaderElection = null;
        private Function<JobID, LeaderRetrievalService> jmLeaderRetrieverFunction = null;

        public Builder setRpcService(RpcService rpcService) {
            this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
            this.needStopRpcService = false;
            return this;
        }

        public Builder setRmLeaderElection(TestingLeaderElection rmLeaderElection) {
            this.rmLeaderElection = (TestingLeaderElection)Preconditions.checkNotNull((Object)rmLeaderElection);
            return this;
        }

        public Builder setJmLeaderRetrieverFunction(Function<JobID, LeaderRetrievalService> jmLeaderRetrieverFunction) {
            this.jmLeaderRetrieverFunction = (Function)Preconditions.checkNotNull(jmLeaderRetrieverFunction);
            return this;
        }

        public TestingResourceManagerService build() throws Exception {
            this.rpcService = this.rpcService != null ? this.rpcService : new TestingRpcService();
            this.rmLeaderElection = this.rmLeaderElection != null ? this.rmLeaderElection : new TestingLeaderElection();
            TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
            haServices.setResourceManagerLeaderElection(this.rmLeaderElection);
            if (this.jmLeaderRetrieverFunction != null) {
                haServices.setJobMasterLeaderRetrieverFunction(this.jmLeaderRetrieverFunction);
            }
            TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
            return new TestingResourceManagerService(ResourceManagerServiceImpl.create((ResourceManagerFactory)StandaloneResourceManagerFactory.getInstance(), (Configuration)new Configuration(), (ResourceID)ResourceID.generate(), (RpcService)this.rpcService, (HighAvailabilityServices)haServices, (HeartbeatServices)new TestingHeartbeatServices(), (DelegationTokenManager)new NoOpDelegationTokenManager(), (FatalErrorHandler)fatalErrorHandler, (ClusterInformation)new ClusterInformation("localhost", 1234), null, (MetricRegistry)TestingMetricRegistry.builder().build(), (String)"localhost", (Executor)ForkJoinPool.commonPool()), this.rmLeaderElection, fatalErrorHandler, this.rpcService, this.needStopRpcService);
        }
    }
}

