/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerOperatorMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.util.AbstractID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobManagerOperatorGroupTest {
    private static final MetricRegistry registry = TestingMetricRegistry.builder().build();

    JobManagerOperatorGroupTest() {
    }

    @Test
    void addOperators() {
        JobManagerJobMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        JobVertexID jobVertexId1 = new JobVertexID();
        JobVertexID jobVertexId2 = new JobVertexID();
        OperatorID operatorId1 = new OperatorID();
        OperatorID operatorId2 = new OperatorID();
        JobManagerOperatorMetricGroup jmOperatorGroup11 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId1, "taskName1", operatorId1, "opName1");
        JobManagerOperatorMetricGroup jmOperatorGroup12 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId1, "taskName1", operatorId1, "opName1");
        JobManagerOperatorMetricGroup jmOperatorGroup21 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId2, "taskName3", operatorId2, "opName3");
        Assertions.assertThat((Object)jmOperatorGroup11).isEqualTo((Object)jmOperatorGroup12);
        Assertions.assertThat((int)jmJobGroup.numRegisteredOperatorMetricGroups()).isEqualTo(2);
        jmOperatorGroup11.close();
        Assertions.assertThat((boolean)jmOperatorGroup11.isClosed()).isTrue();
        Assertions.assertThat((int)jmJobGroup.numRegisteredOperatorMetricGroups()).isEqualTo(1);
        jmOperatorGroup21.close();
        Assertions.assertThat((boolean)jmOperatorGroup21.isClosed()).isTrue();
        Assertions.assertThat((int)jmJobGroup.numRegisteredOperatorMetricGroups()).isEqualTo(0);
    }

    @Test
    void testCloseClosesAll() {
        JobManagerJobMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"theHostName").addJob(new JobID(), "myJobName");
        JobVertexID jobVertexId1 = new JobVertexID();
        JobVertexID jobVertexId2 = new JobVertexID();
        OperatorID operatorId1 = new OperatorID();
        OperatorID operatorId2 = new OperatorID();
        JobManagerOperatorMetricGroup jmOperatorGroup11 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId1, "taskName1", operatorId1, "opName1");
        JobManagerOperatorMetricGroup jmOperatorGroup12 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId1, "taskName1", operatorId1, "opName1");
        JobManagerOperatorMetricGroup jmOperatorGroup21 = jmJobGroup.getOrAddOperator((AbstractID)jobVertexId2, "taskName3", operatorId2, "opName3");
        Assertions.assertThat((Object)jmOperatorGroup11).isEqualTo((Object)jmOperatorGroup12);
        Assertions.assertThat((int)jmJobGroup.numRegisteredOperatorMetricGroups()).isEqualTo(2);
        jmJobGroup.close();
        Assertions.assertThat((boolean)jmOperatorGroup11.isClosed()).isTrue();
        Assertions.assertThat((boolean)jmOperatorGroup21.isClosed()).isTrue();
    }

    @Test
    void testGenerateScopeDefault() {
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        Assertions.assertThat((Object[])jmJobGroup.getScopeComponents()).containsExactly((Object[])new String[]{"localhost", "jobmanager", "myJobName", "opName"});
        Assertions.assertThat((String)jmJobGroup.getMetricIdentifier("name")).isEqualTo("localhost.jobmanager.myJobName.opName.name");
    }

    @Test
    void testGenerateScopeCustom() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_OPERATOR, "constant.<host>.foo.<host>.<job_id>.<job_name>.<task_id>.<task_name>.<operator_id>.<operator_name>");
        TestingMetricRegistry registry = TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)cfg)).build();
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        Assertions.assertThat((Object[])jmJobGroup.getScopeComponents()).containsExactly((Object[])new String[]{"constant", "host", "foo", "host", jobId.toString(), "myJobName", jobVertexId.toString(), "taskName", operatorId.toString(), "opName"});
        Assertions.assertThat((String)jmJobGroup.getMetricIdentifier("name")).isEqualTo(String.format("constant.host.foo.host.%s.myJobName.%s.taskName.%s.opName.name", jobId, jobVertexId, operatorId));
    }

    @Test
    void testGenerateScopeCustomWildcard() {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_JM, "peter");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_JOB, "*.some-constant.<job_id>");
        cfg.setString(MetricOptions.SCOPE_NAMING_JM_OPERATOR, "*.other-constant.<operator_id>");
        TestingMetricRegistry registry = TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)cfg)).build();
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        Assertions.assertThat((Object[])jmJobGroup.getScopeComponents()).containsExactly((Object[])new String[]{"peter", "some-constant", jobId.toString(), "other-constant", operatorId.toString()});
        Assertions.assertThat((String)jmJobGroup.getMetricIdentifier("name")).isEqualTo(String.format("peter.some-constant.%s.other-constant.%s.name", jobId, operatorId));
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        QueryScopeInfo.JobManagerOperatorQueryScopeInfo info = jmJobGroup.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEqualTo("");
        Assertions.assertThat((String)info.jobID).isEqualTo(jobId.toString());
        Assertions.assertThat((String)info.vertexID).isEqualTo(jobVertexId.toString());
        Assertions.assertThat((String)info.operatorName).isEqualTo("opName");
    }
}

