/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.InternalOperatorCoordinatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalSplitEnumeratorMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerOperatorMetricGroup;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.util.AbstractID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InternalSplitEnumeratorGroupTest {
    private static final MetricRegistry registry = TestingMetricRegistry.builder().build();

    InternalSplitEnumeratorGroupTest() {
    }

    @Test
    void testGenerateScopeDefault() {
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        InternalOperatorCoordinatorMetricGroup operatorCoordinatorMetricGroup = new InternalOperatorCoordinatorMetricGroup((MetricGroup)jmJobGroup);
        InternalSplitEnumeratorMetricGroup splitEnumeratorMetricGroup = new InternalSplitEnumeratorMetricGroup((MetricGroup)operatorCoordinatorMetricGroup);
        Assertions.assertThat((Object[])splitEnumeratorMetricGroup.getScopeComponents()).containsExactly((Object[])new String[]{"localhost", "jobmanager", "myJobName", "opName", "coordinator", "enumerator"});
        Assertions.assertThat((String)splitEnumeratorMetricGroup.getMetricIdentifier("name")).isEqualTo("localhost.jobmanager.myJobName.opName.coordinator.enumerator.name");
    }
}

