/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.metrics.util.TestMeter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetricQueryServiceTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)1L);
    private static TestingRpcService rpcService;

    @BeforeClass
    public static void setupClass() {
        rpcService = new TestingRpcService();
    }

    @After
    public void teardown() {
        rpcService.clearGateways();
    }

    @AfterClass
    public static void teardownClass() {
        if (rpcService != null) {
            rpcService.closeAsync();
            rpcService = null;
        }
    }

    @Test
    public void testCreateDump() throws Exception {
        MetricQueryService queryService = MetricQueryService.createMetricQueryService((RpcService)rpcService, (ResourceID)ResourceID.generate(), (long)Long.MAX_VALUE);
        queryService.start();
        SimpleCounter c = new SimpleCounter();
        Gauge g = () -> "Hello";
        TestHistogram h = new TestHistogram();
        TestMeter m = new TestMeter();
        TaskManagerMetricGroup tm = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
        queryService.addMetric("counter", (Metric)c, (AbstractMetricGroup)tm);
        queryService.addMetric("gauge", (Metric)g, (AbstractMetricGroup)tm);
        queryService.addMetric("histogram", (Metric)h, (AbstractMetricGroup)tm);
        queryService.addMetric("meter", (Metric)m, (AbstractMetricGroup)tm);
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assert.assertTrue((dump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedGauges.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedMeters.length > 0 ? 1 : 0) != 0);
        queryService.removeMetric((Metric)c);
        queryService.removeMetric((Metric)g);
        queryService.removeMetric((Metric)h);
        queryService.removeMetric((Metric)m);
        MetricDumpSerialization.MetricSerializationResult emptyDump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assert.assertEquals((long)0L, (long)emptyDump.serializedCounters.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedGauges.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedHistograms.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedMeters.length);
    }

    @Test
    public void testHandleOversizedMetricMessage() throws Exception {
        long sizeLimit = 200L;
        MetricQueryService queryService = MetricQueryService.createMetricQueryService((RpcService)rpcService, (ResourceID)ResourceID.generate(), (long)200L);
        queryService.start();
        TaskManagerMetricGroup tm = UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup();
        String gaugeValue = "Hello";
        long requiredGaugesToExceedLimit = 200L / (long)"Hello".length() + 1L;
        List<Tuple2> gauges = LongStream.range(0L, requiredGaugesToExceedLimit).mapToObj(x -> Tuple2.of((Object)("gauge" + x), () -> "Hello" + x)).collect(Collectors.toList());
        gauges.forEach(gauge -> queryService.addMetric((String)gauge.f0, (Metric)gauge.f1, (AbstractMetricGroup)tm));
        queryService.addMetric("counter", (Metric)new SimpleCounter(), (AbstractMetricGroup)tm);
        queryService.addMetric("histogram", (Metric)new TestHistogram(), (AbstractMetricGroup)tm);
        queryService.addMetric("meter", (Metric)new TestMeter(), (AbstractMetricGroup)tm);
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assert.assertTrue((dump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numCounters);
        Assert.assertTrue((dump.serializedMeters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numMeters);
        Assert.assertEquals((long)0L, (long)dump.serializedGauges.length);
        Assert.assertEquals((long)0L, (long)dump.numGauges);
        Assert.assertTrue((dump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numHistograms);
        for (int x2 = 1; x2 < gauges.size(); ++x2) {
            queryService.removeMetric((Metric)((Tuple2)gauges.get((int)x2)).f1);
        }
        MetricDumpSerialization.MetricSerializationResult recoveredDump = (MetricDumpSerialization.MetricSerializationResult)queryService.queryMetrics(TIMEOUT).get();
        Assert.assertTrue((recoveredDump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numCounters);
        Assert.assertTrue((recoveredDump.serializedMeters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numMeters);
        Assert.assertTrue((recoveredDump.serializedGauges.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numGauges);
        Assert.assertTrue((recoveredDump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numHistograms);
    }
}

