/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class PendingCheckpointStatsTest {
    @Test
    void testReportSubtaskStats() {
        SubtaskStateStats subtask;
        int i;
        long checkpointId = 2147484869L;
        long triggerTimestamp = 2147482408L;
        CheckpointProperties props = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        int totalSubtaskCount = task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks();
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        PendingCheckpointStats pending = new PendingCheckpointStats(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats);
        Assertions.assertThat((long)pending.getCheckpointId()).isEqualTo(checkpointId);
        Assertions.assertThat((long)pending.getTriggerTimestamp()).isEqualTo(triggerTimestamp);
        Assertions.assertThat((Object)pending.getProperties()).isEqualTo((Object)props);
        Assertions.assertThat((Comparable)pending.getStatus()).isEqualTo((Object)CheckpointStatsStatus.IN_PROGRESS);
        Assertions.assertThat((int)pending.getNumberOfAcknowledgedSubtasks()).isZero();
        Assertions.assertThat((long)pending.getStateSize()).isZero();
        Assertions.assertThat((int)pending.getNumberOfSubtasks()).isEqualTo(totalSubtaskCount);
        Assertions.assertThat((Object)pending.getLatestAcknowledgedSubtaskStats()).isNull();
        Assertions.assertThat((long)pending.getLatestAckTimestamp()).isEqualTo(-1L);
        Assertions.assertThat((long)pending.getEndToEndDuration()).isEqualTo(-1L);
        Assertions.assertThat((Object)pending.getTaskStateStats(task1.getJobVertexId())).isEqualTo((Object)task1);
        Assertions.assertThat((Object)pending.getTaskStateStats(task2.getJobVertexId())).isEqualTo((Object)task2);
        Assertions.assertThat((Object)pending.getTaskStateStats(new JobVertexID())).isNull();
        Assertions.assertThat((boolean)pending.reportSubtaskStats(new JobVertexID(), this.createSubtaskStats(0, false))).isFalse();
        long stateSize = 0L;
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            subtask = this.createSubtaskStats(i, false);
            stateSize += subtask.getStateSize();
            pending.reportSubtaskStats(task1.getJobVertexId(), subtask);
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isFalse();
            Assertions.assertThat((Object)pending.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)subtask);
            Assertions.assertThat((long)pending.getLatestAckTimestamp()).isEqualTo(subtask.getAckTimestamp());
            Assertions.assertThat((long)pending.getEndToEndDuration()).isEqualTo(subtask.getAckTimestamp() - triggerTimestamp);
            Assertions.assertThat((long)pending.getStateSize()).isEqualTo(stateSize);
        }
        Assertions.assertThat((boolean)pending.reportSubtaskStats(task1.getJobVertexId(), task1.getSubtaskStats()[0])).isFalse();
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            subtask = this.createSubtaskStats(i, true);
            stateSize += subtask.getStateSize();
            pending.reportSubtaskStats(task2.getJobVertexId(), subtask);
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isTrue();
            Assertions.assertThat((Object)pending.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)subtask);
            Assertions.assertThat((long)pending.getLatestAckTimestamp()).isEqualTo(subtask.getAckTimestamp());
            Assertions.assertThat((long)pending.getEndToEndDuration()).isEqualTo(subtask.getAckTimestamp() - triggerTimestamp);
            Assertions.assertThat((long)pending.getStateSize()).isEqualTo(stateSize);
        }
        Assertions.assertThat((int)task1.getNumberOfAcknowledgedSubtasks()).isEqualTo(task1.getNumberOfSubtasks());
        Assertions.assertThat((int)task2.getNumberOfAcknowledgedSubtasks()).isEqualTo(task2.getNumberOfSubtasks());
    }

    @Test
    void testReportCompletedCheckpoint() {
        int i;
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CheckpointStatsTracker callback = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        PendingCheckpointStats pending = new PendingCheckpointStats(0L, 1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks(), taskStats);
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task1.getJobVertexId(), this.createSubtaskStats(i, false));
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isFalse();
        }
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task2.getJobVertexId(), this.createSubtaskStats(i, true));
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isTrue();
        }
        String externalPath = "asdjkasdjkasd";
        callback.reportCompletedCheckpoint(pending.toCompletedCheckpointStats(externalPath));
        ArgumentCaptor args = ArgumentCaptor.forClass(CompletedCheckpointStats.class);
        ((CheckpointStatsTracker)Mockito.verify((Object)callback)).reportCompletedCheckpoint((CompletedCheckpointStats)args.capture());
        CompletedCheckpointStats completed = (CompletedCheckpointStats)args.getValue();
        Assertions.assertThat((Object)completed).isNotNull();
        Assertions.assertThat((Comparable)completed.getStatus()).isEqualTo((Object)CheckpointStatsStatus.COMPLETED);
        Assertions.assertThat((boolean)completed.isDiscarded()).isFalse();
        completed.discard();
        Assertions.assertThat((boolean)completed.isDiscarded()).isTrue();
        Assertions.assertThat((String)completed.getExternalPath()).isEqualTo(externalPath);
        Assertions.assertThat((long)completed.getCheckpointId()).isEqualTo(pending.getCheckpointId());
        Assertions.assertThat((int)completed.getNumberOfAcknowledgedSubtasks()).isEqualTo(pending.getNumberOfAcknowledgedSubtasks());
        Assertions.assertThat((Object)completed.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)pending.getLatestAcknowledgedSubtaskStats());
        Assertions.assertThat((long)completed.getLatestAckTimestamp()).isEqualTo(pending.getLatestAckTimestamp());
        Assertions.assertThat((long)completed.getEndToEndDuration()).isEqualTo(pending.getEndToEndDuration());
        Assertions.assertThat((long)completed.getStateSize()).isEqualTo(pending.getStateSize());
        Assertions.assertThat((boolean)completed.isUnalignedCheckpoint()).isTrue();
        Assertions.assertThat((Object)completed.getTaskStateStats(task1.getJobVertexId())).isEqualTo((Object)task1);
        Assertions.assertThat((Object)completed.getTaskStateStats(task2.getJobVertexId())).isEqualTo((Object)task2);
    }

    @Test
    void testReportFailedCheckpoint() {
        int i;
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CheckpointStatsTracker callback = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        long triggerTimestamp = 123123L;
        PendingCheckpointStats pending = new PendingCheckpointStats(0L, triggerTimestamp, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), task1.getNumberOfSubtasks() + task2.getNumberOfSubtasks(), taskStats);
        for (i = 0; i < task1.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task1.getJobVertexId(), this.createSubtaskStats(i, false));
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isFalse();
        }
        for (i = 0; i < task2.getNumberOfSubtasks(); ++i) {
            pending.reportSubtaskStats(task2.getJobVertexId(), this.createSubtaskStats(i, true));
            Assertions.assertThat((boolean)pending.isUnalignedCheckpoint()).isTrue();
        }
        Exception cause = new Exception("test exception");
        long failureTimestamp = 112211137L;
        callback.reportFailedCheckpoint(pending.toFailedCheckpoint(failureTimestamp, (Throwable)cause));
        ArgumentCaptor args = ArgumentCaptor.forClass(FailedCheckpointStats.class);
        ((CheckpointStatsTracker)Mockito.verify((Object)callback)).reportFailedCheckpoint((FailedCheckpointStats)args.capture());
        FailedCheckpointStats failed = (FailedCheckpointStats)args.getValue();
        Assertions.assertThat((Object)failed).isNotNull();
        Assertions.assertThat((Comparable)failed.getStatus()).isEqualTo((Object)CheckpointStatsStatus.FAILED);
        Assertions.assertThat((long)failed.getFailureTimestamp()).isEqualTo(failureTimestamp);
        Assertions.assertThat((String)failed.getFailureMessage()).isEqualTo(cause.getMessage());
        Assertions.assertThat((long)failed.getCheckpointId()).isEqualTo(pending.getCheckpointId());
        Assertions.assertThat((int)failed.getNumberOfAcknowledgedSubtasks()).isEqualTo(pending.getNumberOfAcknowledgedSubtasks());
        Assertions.assertThat((Object)failed.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)pending.getLatestAcknowledgedSubtaskStats());
        Assertions.assertThat((long)failed.getLatestAckTimestamp()).isEqualTo(pending.getLatestAckTimestamp());
        Assertions.assertThat((long)failed.getEndToEndDuration()).isEqualTo(failureTimestamp - triggerTimestamp);
        Assertions.assertThat((long)failed.getStateSize()).isEqualTo(pending.getStateSize());
        Assertions.assertThat((boolean)failed.isUnalignedCheckpoint()).isTrue();
        Assertions.assertThat((Object)failed.getTaskStateStats(task1.getJobVertexId())).isEqualTo((Object)task1);
        Assertions.assertThat((Object)failed.getTaskStateStats(task2.getJobVertexId())).isEqualTo((Object)task2);
    }

    @Test
    void testIsJavaSerializable() throws Exception {
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        PendingCheckpointStats pending = new PendingCheckpointStats(123123123L, 10123L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats);
        PendingCheckpointStats copy = (PendingCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)pending);
        Assertions.assertThat((long)copy.getCheckpointId()).isEqualTo(pending.getCheckpointId());
        Assertions.assertThat((long)copy.getTriggerTimestamp()).isEqualTo(pending.getTriggerTimestamp());
        Assertions.assertThat((Object)copy.getProperties()).isEqualTo((Object)pending.getProperties());
        Assertions.assertThat((int)copy.getNumberOfSubtasks()).isEqualTo(pending.getNumberOfSubtasks());
        Assertions.assertThat((int)copy.getNumberOfAcknowledgedSubtasks()).isEqualTo(pending.getNumberOfAcknowledgedSubtasks());
        Assertions.assertThat((long)copy.getEndToEndDuration()).isEqualTo(pending.getEndToEndDuration());
        Assertions.assertThat((long)copy.getStateSize()).isEqualTo(pending.getStateSize());
        Assertions.assertThat((Object)copy.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)pending.getLatestAcknowledgedSubtaskStats());
        Assertions.assertThat((Comparable)copy.getStatus()).isEqualTo((Object)pending.getStatus());
    }

    private SubtaskStateStats createSubtaskStats(int index, boolean unalignedCheckpoint) {
        return new SubtaskStateStats(index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, Integer.MAX_VALUE + (long)index, unalignedCheckpoint, true);
    }
}

