/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerInfo;

public class ResourceReleaseResult {
    private final List<PendingTaskManager> pendingTaskManagersToRelease;
    private final List<TaskManagerInfo> taskManagersToRelease;

    public ResourceReleaseResult(List<PendingTaskManager> pendingTaskManagersToRelease, List<TaskManagerInfo> taskManagersToRelease) {
        this.pendingTaskManagersToRelease = pendingTaskManagersToRelease;
        this.taskManagersToRelease = taskManagersToRelease;
    }

    public List<PendingTaskManager> getPendingTaskManagersToRelease() {
        return this.pendingTaskManagersToRelease;
    }

    public List<TaskManagerInfo> getTaskManagersToRelease() {
        return this.taskManagersToRelease;
    }

    public boolean needRelease() {
        return !this.pendingTaskManagersToRelease.isEmpty() || !this.taskManagersToRelease.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<PendingTaskManager> pendingTaskManagersToRelease = new ArrayList<PendingTaskManager>();
        private final List<TaskManagerInfo> taskManagersToRelease = new ArrayList<TaskManagerInfo>();

        public Builder addPendingTaskManagerToRelease(PendingTaskManager pendingTaskManager) {
            this.pendingTaskManagersToRelease.add(pendingTaskManager);
            return this;
        }

        public Builder addTaskManagerToRelease(TaskManagerInfo taskManagerInfo) {
            this.taskManagersToRelease.add(taskManagerInfo);
            return this;
        }

        public ResourceReleaseResult build() {
            return new ResourceReleaseResult(this.pendingTaskManagersToRelease, this.taskManagersToRelease);
        }
    }
}

