/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderElectionException;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ZooKeeperLeaderElectionDriver
implements LeaderElectionDriver,
LeaderLatchListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperLeaderElectionDriver.class);
    private final CuratorFramework client;
    private final LeaderLatch leaderLatch;
    private final TreeCache cache;
    private final String connectionInformationPath;
    private final String leaderLatchPath;
    private final ConnectionStateListener listener = (client, newState) -> this.handleStateChange(newState);
    private final LeaderElectionEventHandler leaderElectionEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private volatile boolean running;

    public ZooKeeperLeaderElectionDriver(CuratorFramework client2, String path, LeaderElectionEventHandler leaderElectionEventHandler, FatalErrorHandler fatalErrorHandler) throws Exception {
        Preconditions.checkNotNull((Object)path);
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client2);
        this.connectionInformationPath = ZooKeeperUtils.generateConnectionInformationPath(path);
        this.leaderElectionEventHandler = (LeaderElectionEventHandler)Preconditions.checkNotNull((Object)leaderElectionEventHandler);
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler);
        this.leaderLatchPath = ZooKeeperUtils.generateLeaderLatchPath(path);
        this.leaderLatch = new LeaderLatch(client2, this.leaderLatchPath);
        this.cache = ZooKeeperUtils.createTreeCache(client2, this.connectionInformationPath, this::retrieveLeaderInformationFromZooKeeper);
        this.running = true;
        this.leaderLatch.addListener((LeaderLatchListener)this);
        this.leaderLatch.start();
        this.cache.start();
        client2.getConnectionStateListenable().addListener((Object)this.listener);
    }

    @Override
    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOG.info("Closing {}", (Object)this);
        this.client.getConnectionStateListenable().removeListener((Object)this.listener);
        Exception exception = null;
        try {
            this.cache.close();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.leaderLatch.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        if (exception != null) {
            throw new Exception("Could not properly stop the ZooKeeperLeaderElectionDriver.", exception);
        }
    }

    @Override
    public boolean hasLeadership() {
        return this.running && this.leaderLatch.hasLeadership();
    }

    public void isLeader() {
        this.leaderElectionEventHandler.onGrantLeadership(UUID.randomUUID());
    }

    public void notLeader() {
        this.leaderElectionEventHandler.onRevokeLeadership();
    }

    private void retrieveLeaderInformationFromZooKeeper() throws Exception {
        if (this.leaderLatch.hasLeadership()) {
            ChildData childData = this.cache.getCurrentData(this.connectionInformationPath);
            this.leaderElectionEventHandler.onLeaderInformationChange(childData == null ? LeaderInformation.empty() : ZooKeeperUtils.readLeaderInformation(childData.getData()));
        }
    }

    @Override
    public void writeLeaderInformation(LeaderInformation leaderInformation) {
        Preconditions.checkState((boolean)this.running, (Object)"Leader information can only be written if the driver hasn't been closed, yet.");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write leader information: {}.", (Object)leaderInformation);
        }
        if (leaderInformation.isEmpty()) {
            return;
        }
        try {
            ZooKeeperUtils.writeLeaderInformationToZooKeeper(leaderInformation, this.client, () -> ((LeaderLatch)this.leaderLatch).hasLeadership(), this.connectionInformationPath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Successfully wrote leader information: {}.", (Object)leaderInformation);
            }
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)((Object)new LeaderElectionException("Could not write leader address and leader session ID to ZooKeeper.", e)));
        }
    }

    private void handleStateChange(ConnectionState newState) {
        switch (newState) {
            case CONNECTED: {
                LOG.debug("Connected to ZooKeeper quorum. Leader election can start.");
                break;
            }
            case SUSPENDED: {
                LOG.warn("Connection to ZooKeeper suspended, waiting for reconnection.");
                break;
            }
            case RECONNECTED: {
                LOG.info("Connection to ZooKeeper was reconnected. Leader election can be restarted.");
                break;
            }
            case LOST: {
                LOG.warn("Connection to ZooKeeper lost. The contender no longer participates in the leader election.");
            }
        }
    }

    public String toString() {
        return String.format("%s{leaderLatchPath='%s', connectionInformationPath='%s'}", this.getClass().getSimpleName(), this.leaderLatchPath, this.connectionInformationPath);
    }

    @VisibleForTesting
    String getConnectionInformationPath() {
        return this.connectionInformationPath;
    }
}

