/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderelection.AbstractLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.util.Preconditions;

public class StandaloneLeaderElectionService
extends AbstractLeaderElectionService {
    private LeaderContender contender = null;

    @Override
    protected void register(LeaderContender newContender) throws Exception {
        if (this.contender != null) {
            throw new IllegalArgumentException("Leader election service cannot be started multiple times.");
        }
        this.contender = (LeaderContender)Preconditions.checkNotNull((Object)newContender);
        this.contender.grantLeadership(HighAvailabilityServices.DEFAULT_LEADER_ID);
    }

    @Override
    protected void remove(LeaderContender contender) {
        Preconditions.checkArgument((contender == this.contender ? 1 : 0) != 0);
        if (this.contender != null) {
            this.contender.revokeLeadership();
            this.contender = null;
        }
    }

    @Override
    protected void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
    }

    @Override
    protected boolean hasLeadership(UUID leaderSessionId) {
        return this.contender != null && HighAvailabilityServices.DEFAULT_LEADER_ID.equals(leaderSessionId);
    }
}

