/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.AbstractLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.util.Preconditions;

class DefaultLeaderElection
implements LeaderElection {
    private final AbstractLeaderElectionService parentService;
    @Nullable
    private LeaderContender leaderContender;

    DefaultLeaderElection(AbstractLeaderElectionService parentService) {
        this.parentService = parentService;
    }

    @Override
    public void startLeaderElection(LeaderContender contender) throws Exception {
        Preconditions.checkState((this.leaderContender == null ? 1 : 0) != 0, (Object)"There shouldn't be any LeaderContender registered, yet.");
        this.leaderContender = (LeaderContender)Preconditions.checkNotNull((Object)contender);
        this.parentService.register(this.leaderContender);
    }

    @Override
    public void confirmLeadership(UUID leaderSessionID, String leaderAddress) {
        this.parentService.confirmLeadership(leaderSessionID, leaderAddress);
    }

    @Override
    public boolean hasLeadership(UUID leaderSessionId) {
        return this.parentService.hasLeadership(leaderSessionId);
    }

    @Override
    public void close() throws Exception {
        if (this.leaderContender != null) {
            this.parentService.remove(this.leaderContender);
            this.leaderContender = null;
        }
    }
}

