/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public final class SlotInfoWithUtilization
implements SlotInfo {
    private final SlotInfo slotInfoDelegate;
    private final Function<ResourceID, Double> taskExecutorUtilizationLookup;

    private SlotInfoWithUtilization(SlotInfo slotInfo, Function<ResourceID, Double> taskExecutorUtilizationLookup) {
        this.slotInfoDelegate = slotInfo;
        this.taskExecutorUtilizationLookup = taskExecutorUtilizationLookup;
    }

    public double getTaskExecutorUtilization() {
        return this.taskExecutorUtilizationLookup.apply(this.slotInfoDelegate.getTaskManagerLocation().getResourceID());
    }

    @Override
    public AllocationID getAllocationId() {
        return this.slotInfoDelegate.getAllocationId();
    }

    @Override
    public TaskManagerLocation getTaskManagerLocation() {
        return this.slotInfoDelegate.getTaskManagerLocation();
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.slotInfoDelegate.getPhysicalSlotNumber();
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.slotInfoDelegate.getResourceProfile();
    }

    @Override
    public boolean willBeOccupiedIndefinitely() {
        return this.slotInfoDelegate.willBeOccupiedIndefinitely();
    }

    public static SlotInfoWithUtilization from(SlotInfo slotInfo, Function<ResourceID, Double> taskExecutorUtilizationLookup) {
        return new SlotInfoWithUtilization(slotInfo, taskExecutorUtilizationLookup);
    }
}

