/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousAllocationSlotSelectionStrategy
implements SlotSelectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PreviousAllocationSlotSelectionStrategy.class);
    private final SlotSelectionStrategy fallbackSlotSelectionStrategy;

    private PreviousAllocationSlotSelectionStrategy(SlotSelectionStrategy fallbackSlotSelectionStrategy) {
        this.fallbackSlotSelectionStrategy = fallbackSlotSelectionStrategy;
    }

    @Override
    public Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull Collection<SlotInfoWithUtilization> availableSlots, @Nonnull SlotProfile slotProfile) {
        LOG.debug("Select best slot for profile {}.", (Object)slotProfile);
        Collection<AllocationID> priorAllocations = slotProfile.getPreferredAllocations();
        if (!priorAllocations.isEmpty()) {
            for (SlotInfoWithUtilization availableSlot : availableSlots) {
                if (!priorAllocations.contains((Object)availableSlot.getAllocationId())) continue;
                return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(availableSlot, Locality.LOCAL));
            }
        }
        Set<AllocationID> blackListedAllocations = slotProfile.getReservedAllocations();
        Collection<SlotInfoWithUtilization> availableAndAllowedSlots = this.computeWithoutBlacklistedSlots(availableSlots, blackListedAllocations);
        return this.fallbackSlotSelectionStrategy.selectBestSlotForProfile(availableAndAllowedSlots, slotProfile);
    }

    @Nonnull
    private Collection<SlotInfoWithUtilization> computeWithoutBlacklistedSlots(@Nonnull Collection<SlotInfoWithUtilization> availableSlots, @Nonnull Set<AllocationID> blacklistedAllocations) {
        if (blacklistedAllocations.isEmpty()) {
            return Collections.unmodifiableCollection(availableSlots);
        }
        ArrayList<SlotInfoWithUtilization> availableAndAllowedSlots = new ArrayList<SlotInfoWithUtilization>(availableSlots.size());
        for (SlotInfoWithUtilization availableSlot : availableSlots) {
            if (blacklistedAllocations.contains((Object)availableSlot.getAllocationId())) continue;
            availableAndAllowedSlots.add(availableSlot);
        }
        return availableAndAllowedSlots;
    }

    public static PreviousAllocationSlotSelectionStrategy create() {
        return PreviousAllocationSlotSelectionStrategy.create(LocationPreferenceSlotSelectionStrategy.createDefault());
    }

    public static PreviousAllocationSlotSelectionStrategy create(SlotSelectionStrategy fallbackSlotSelectionStrategy) {
        return new PreviousAllocationSlotSelectionStrategy(fallbackSlotSelectionStrategy);
    }
}

