/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class EvenlySpreadOutLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    EvenlySpreadOutLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotInfoWithUtilization> availableSlots, @Nonnull ResourceProfile resourceProfile) {
        return availableSlots.stream().filter(slotInfoWithUtilization -> slotInfoWithUtilization.getResourceProfile().isMatching(resourceProfile)).min(Comparator.comparing(SlotInfoWithUtilization::getTaskExecutorUtilization)).map(slotInfoWithUtilization -> SlotSelectionStrategy.SlotInfoAndLocality.of(slotInfoWithUtilization, Locality.UNCONSTRAINED));
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, Supplier<Double> taskExecutorUtilizationSupplier) {
        return (double)(localWeigh * 20 + hostLocalWeigh * 2) - taskExecutorUtilizationSupplier.get();
    }
}

