/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class DefaultLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    DefaultLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotInfoWithUtilization> availableSlots, @Nonnull ResourceProfile resourceProfile) {
        for (SlotInfoWithUtilization candidate : availableSlots) {
            if (!candidate.getResourceProfile().isMatching(resourceProfile)) continue;
            return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(candidate, Locality.UNCONSTRAINED));
        }
        return Optional.empty();
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, Supplier<Double> taskExecutorUtilizationSupplier) {
        return localWeigh * 10 + hostLocalWeigh;
    }
}

