/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.util.ExceptionUtils;

public class TieredStorageProducerClient {
    private final boolean isBroadcastOnly;
    private final int numSubpartitions;
    private final BufferAccumulator bufferAccumulator;
    private final BufferCompressor bufferCompressor;
    private final List<TierProducerAgent> tierProducerAgents;

    public TieredStorageProducerClient(int numSubpartitions, boolean isBroadcastOnly, BufferAccumulator bufferAccumulator, @Nullable BufferCompressor bufferCompressor, List<TierProducerAgent> tierProducerAgents) {
        this.isBroadcastOnly = isBroadcastOnly;
        this.numSubpartitions = numSubpartitions;
        this.bufferAccumulator = bufferAccumulator;
        this.bufferCompressor = bufferCompressor;
        this.tierProducerAgents = tierProducerAgents;
        bufferAccumulator.setup(this::writeAccumulatedBuffers);
    }

    public void write(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        if (isBroadcast && !this.isBroadcastOnly) {
            for (int i = 0; i < this.numSubpartitions; ++i) {
                this.bufferAccumulator.receive(record.duplicate(), subpartitionId, dataType);
            }
        } else {
            this.bufferAccumulator.receive(record, subpartitionId, dataType);
        }
    }

    public void close() {
        this.bufferAccumulator.close();
        this.tierProducerAgents.forEach(TierProducerAgent::close);
    }

    private void writeAccumulatedBuffers(TieredStorageSubpartitionId subpartitionId, List<Buffer> accumulatedBuffers) {
        try {
            for (Buffer finishedBuffer : accumulatedBuffers) {
                this.writeAccumulatedBuffer(subpartitionId, finishedBuffer);
            }
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private void writeAccumulatedBuffer(TieredStorageSubpartitionId subpartitionId, Buffer accumulatedBuffer) throws IOException {
    }
}

