/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.Preconditions;

public class TieredStorageMemoryManagerImpl
implements TieredStorageMemoryManager {
    private static final int INITIAL_REQUEST_BUFFER_TIMEOUT_FOR_RECLAIMING_MS = 50;
    private final Map<Object, TieredStorageMemorySpec> tieredMemorySpecs;
    private final List<Runnable> bufferReclaimRequestListeners;
    private final float numTriggerReclaimBuffersRatio;
    private final boolean mayReclaimBuffer;
    private final AtomicInteger numRequestedBuffers;
    private final Map<Object, AtomicInteger> numOwnerRequestedBuffers;
    @Nullable
    private ScheduledExecutorService executor;
    private BufferPool bufferPool;
    private boolean isInitialized;

    public TieredStorageMemoryManagerImpl(float numTriggerReclaimBuffersRatio, boolean mayReclaimBuffer) {
        this.numTriggerReclaimBuffersRatio = numTriggerReclaimBuffersRatio;
        this.mayReclaimBuffer = mayReclaimBuffer;
        this.tieredMemorySpecs = new HashMap<Object, TieredStorageMemorySpec>();
        this.numRequestedBuffers = new AtomicInteger(0);
        this.numOwnerRequestedBuffers = new ConcurrentHashMap<Object, AtomicInteger>();
        this.bufferReclaimRequestListeners = new ArrayList<Runnable>();
        this.isInitialized = false;
    }

    @Override
    public void setup(BufferPool bufferPool, List<TieredStorageMemorySpec> storageMemorySpecs) {
        this.bufferPool = bufferPool;
        for (TieredStorageMemorySpec memorySpec : storageMemorySpecs) {
            Preconditions.checkState((!this.tieredMemorySpecs.containsKey(memorySpec.getOwner()) ? 1 : 0) != 0, (Object)"Duplicated memory spec.");
            this.tieredMemorySpecs.put(memorySpec.getOwner(), memorySpec);
        }
        if (this.mayReclaimBuffer) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("buffer reclaim checker").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE).build());
        }
        this.isInitialized = true;
    }

    @Override
    public void listenBufferReclaimRequest(Runnable onBufferReclaimRequest) {
        this.bufferReclaimRequestListeners.add(onBufferReclaimRequest);
    }

    @Override
    public BufferBuilder requestBufferBlocking(Object owner) {
        this.checkIsInitialized();
        this.reclaimBuffersIfNeeded();
        CompletableFuture<Void> requestBufferFuture = new CompletableFuture<Void>();
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, 50L);
        MemorySegment memorySegment = null;
        try {
            memorySegment = this.bufferPool.requestMemorySegmentBlocking();
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        requestBufferFuture.complete(null);
        this.incNumRequestedBuffer(owner);
        return new BufferBuilder((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), segment -> this.recycleBuffer(owner, segment));
    }

    @Override
    public int getMaxNonReclaimableBuffers(Object owner) {
        this.checkIsInitialized();
        int numBuffersUsedOrReservedForOtherOwners = 0;
        for (Map.Entry<Object, TieredStorageMemorySpec> memorySpecEntry : this.tieredMemorySpecs.entrySet()) {
            Object userOwner = memorySpecEntry.getKey();
            TieredStorageMemorySpec storageMemorySpec = memorySpecEntry.getValue();
            if (userOwner.equals(owner)) continue;
            int numGuaranteed = storageMemorySpec.getNumGuaranteedBuffers();
            int numRequested = this.numOwnerRequestedBuffer(userOwner);
            numBuffersUsedOrReservedForOtherOwners += Math.max(numGuaranteed, numRequested);
        }
        return this.bufferPool.getNumBuffers() - numBuffersUsedOrReservedForOtherOwners;
    }

    @Override
    public int numOwnerRequestedBuffer(Object owner) {
        AtomicInteger numRequestedBuffer = this.numOwnerRequestedBuffers.get(owner);
        return numRequestedBuffer == null ? 0 : numRequestedBuffer.get();
    }

    @Override
    public void release() {
        Preconditions.checkState((this.numRequestedBuffers.get() == 0 ? 1 : 0) != 0, (Object)"Leaking buffers.");
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new TimeoutException("Timeout for shutting down the buffer reclaim checker executor.");
                }
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    private void scheduleCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayMs) {
        if (!this.mayReclaimBuffer || requestBufferFuture.isDone()) {
            return;
        }
        ((ScheduledExecutorService)Preconditions.checkNotNull((Object)this.executor)).schedule(() -> this.internalCheckRequestBufferFuture(requestBufferFuture, delayMs * 2L), delayMs, TimeUnit.MILLISECONDS);
    }

    private void internalCheckRequestBufferFuture(CompletableFuture<Void> requestBufferFuture, long delayForNextCheckMs) {
        if (requestBufferFuture.isDone()) {
            return;
        }
        this.reclaimBuffersIfNeeded();
        this.scheduleCheckRequestBufferFuture(requestBufferFuture, delayForNextCheckMs);
    }

    private void incNumRequestedBuffer(Object owner) {
        this.numOwnerRequestedBuffers.computeIfAbsent(owner, ignore -> new AtomicInteger(0)).incrementAndGet();
        this.numRequestedBuffers.incrementAndGet();
    }

    private void decNumRequestedBuffer(Object owner) {
        AtomicInteger numOwnerRequestedBuffer = this.numOwnerRequestedBuffers.get(owner);
        ((AtomicInteger)Preconditions.checkNotNull((Object)numOwnerRequestedBuffer)).decrementAndGet();
        this.numRequestedBuffers.decrementAndGet();
    }

    private void reclaimBuffersIfNeeded() {
        if (this.shouldReclaimBuffersBeforeRequesting()) {
            this.bufferReclaimRequestListeners.forEach(Runnable::run);
        }
    }

    private boolean shouldReclaimBuffersBeforeRequesting() {
        int numTotal = this.bufferPool.getNumBuffers();
        int numRequested = this.numRequestedBuffers.get();
        return numRequested >= numTotal || (double)(numRequested + 1) * 1.0 / (double)numTotal > (double)this.numTriggerReclaimBuffersRatio;
    }

    private void recycleBuffer(Object owner, MemorySegment buffer) {
        this.bufferPool.recycle(buffer);
        this.decNumRequestedBuffer(owner);
    }

    private void checkIsInitialized() {
        Preconditions.checkState((boolean)this.isInitialized, (Object)"The memory manager is not in the running state.");
    }
}

