/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;

public class TieredStorageConsumerClient {
    private final List<TierConsumerAgent> tierConsumerAgents;

    public TieredStorageConsumerClient(List<TierFactory> tierFactories) {
        this.tierConsumerAgents = this.createTierConsumerAgents(tierFactories);
    }

    public void start() {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            tierConsumerAgent.start();
        }
    }

    public Optional<Buffer> getNextBuffer(int subpartitionId) {
        return Optional.empty();
    }

    public void close() throws IOException {
        for (TierConsumerAgent tierConsumerAgent : this.tierConsumerAgents) {
            tierConsumerAgent.close();
        }
    }

    private List<TierConsumerAgent> createTierConsumerAgents(List<TierFactory> tierFactories) {
        ArrayList<TierConsumerAgent> tierConsumerAgents = new ArrayList<TierConsumerAgent>();
        for (TierFactory tierFactory : tierFactories) {
            tierConsumerAgents.add(tierFactory.createConsumerAgent());
        }
        return tierConsumerAgents;
    }
}

