/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMasterClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierMasterAgent;

public class TieredInternalShuffleMaster {
    private final TieredStorageMasterClient tieredStorageMasterClient;
    private final Map<JobID, List<ResultPartitionID>> jobPartitionIds;
    private final Map<ResultPartitionID, JobID> partitionJobIds;

    public TieredInternalShuffleMaster(Configuration conf) {
        TieredStorageConfiguration tieredStorageConfiguration = TieredStorageConfiguration.fromConfiguration(conf);
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        List<TierMasterAgent> tierFactories = tieredStorageConfiguration.getTierFactories().stream().map(tierFactory -> tierFactory.createMasterAgent(resourceRegistry)).collect(Collectors.toList());
        this.tieredStorageMasterClient = new TieredStorageMasterClient(tierFactories);
        this.jobPartitionIds = new HashMap<JobID, List<ResultPartitionID>>();
        this.partitionJobIds = new HashMap<ResultPartitionID, JobID>();
    }

    public void addPartition(JobID jobID, ResultPartitionID resultPartitionID) {
        this.jobPartitionIds.computeIfAbsent(jobID, ignore -> new ArrayList()).add(resultPartitionID);
        this.partitionJobIds.put(resultPartitionID, jobID);
        this.tieredStorageMasterClient.addPartition(TieredStorageIdMappingUtils.convertId(resultPartitionID));
    }

    public void releasePartition(ResultPartitionID resultPartitionID) {
        this.tieredStorageMasterClient.releasePartition(TieredStorageIdMappingUtils.convertId(resultPartitionID));
        JobID jobID = this.partitionJobIds.remove(resultPartitionID);
        if (jobID == null) {
            return;
        }
        List<ResultPartitionID> resultPartitionIDs = this.jobPartitionIds.get(jobID);
        if (resultPartitionIDs == null) {
            return;
        }
        resultPartitionIDs.remove(resultPartitionID);
        if (resultPartitionIDs.isEmpty()) {
            this.jobPartitionIds.remove(jobID);
        }
    }

    public void unregisterJob(JobID jobID) {
        List<ResultPartitionID> resultPartitionIDs = this.jobPartitionIds.remove(jobID);
        if (resultPartitionIDs != null) {
            resultPartitionIDs.forEach(resultPartitionID -> {
                this.tieredStorageMasterClient.releasePartition(TieredStorageIdMappingUtils.convertId(resultPartitionID));
                this.partitionJobIds.remove(resultPartitionID);
            });
        }
    }
}

