/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.dispatcher.cleanup.GloballyCleanableResource;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.concurrent.FutureUtils;

public interface HighAvailabilityServices
extends ClientHighAvailabilityServices,
GloballyCleanableResource {
    public static final UUID DEFAULT_LEADER_ID = new UUID(0L, 0L);
    public static final JobID DEFAULT_JOB_ID = new JobID(0L, 0L);

    public LeaderRetrievalService getResourceManagerLeaderRetriever();

    public LeaderRetrievalService getDispatcherLeaderRetriever();

    @Deprecated
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID var1);

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID var1, String var2);

    @Deprecated
    default public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        throw new UnsupportedOperationException("getWebMonitorLeaderRetriever should no longer be used. Instead use #getClusterRestEndpointLeaderRetriever to instantiate the cluster rest endpoint leader retriever. If you called this method, then make sure that #getClusterRestEndpointLeaderRetriever has been implemented by your HighAvailabilityServices implementation.");
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() throws Exception;

    public LeaderElectionService getDispatcherLeaderElectionService() throws Exception;

    public LeaderElectionService getJobManagerLeaderElectionService(JobID var1) throws Exception;

    @Deprecated
    default public LeaderElectionService getWebMonitorLeaderElectionService() {
        throw new UnsupportedOperationException("getWebMonitorLeaderElectionService should no longer be used. Instead use #getClusterRestEndpointLeaderElectionService to instantiate the cluster rest endpoint's leader election service. If you called this method, then make sure that #getClusterRestEndpointLeaderElectionService has been implemented by your HighAvailabilityServices implementation.");
    }

    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() throws Exception;

    public JobGraphStore getJobGraphStore() throws Exception;

    public JobResultStore getJobResultStore() throws Exception;

    public BlobStore createBlobStore() throws IOException;

    default public LeaderElectionService getClusterRestEndpointLeaderElectionService() throws Exception {
        return this.getWebMonitorLeaderElectionService();
    }

    @Override
    default public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return this.getWebMonitorLeaderRetriever();
    }

    @Override
    public void close() throws Exception;

    public void closeAndCleanupAllData() throws Exception;

    @Override
    default public CompletableFuture<Void> globalCleanupAsync(JobID jobId, Executor executor) {
        return FutureUtils.completedVoidFuture();
    }
}

