/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.Objects;
import org.apache.flink.runtime.jobgraph.JobVertexID;

class SubtaskID {
    private final JobVertexID jobVertexID;
    private final int subtaskIndex;

    private SubtaskID(JobVertexID jobVertexID, int subtaskIndex) {
        this.jobVertexID = jobVertexID;
        this.subtaskIndex = subtaskIndex;
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public static SubtaskID of(JobVertexID jobVertexID, int subtaskIndex) {
        return new SubtaskID(jobVertexID, subtaskIndex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskID subtaskID = (SubtaskID)o;
        return this.subtaskIndex == subtaskID.subtaskIndex && Objects.equals(this.jobVertexID, subtaskID.jobVertexID);
    }

    public int hashCode() {
        return Objects.hash(this.jobVertexID, this.subtaskIndex);
    }

    public String toString() {
        return "SubtaskID{jobVertexID=" + this.jobVertexID + ", subtaskIndex=" + this.subtaskIndex + '}';
    }
}

