/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenProvider;
import org.apache.flink.runtime.security.token.hadoop.HadoopDelegationTokenConverter;
import org.apache.flink.runtime.security.token.hadoop.KerberosLoginProvider;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HBaseDelegationTokenProvider
implements DelegationTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseDelegationTokenProvider.class);
    org.apache.hadoop.conf.Configuration hbaseConf;
    private KerberosLoginProvider kerberosLoginProvider;

    public String serviceName() {
        return "hbase";
    }

    public void init(Configuration configuration) throws Exception {
        this.hbaseConf = this.getHBaseConfiguration(configuration);
        this.kerberosLoginProvider = new KerberosLoginProvider(configuration);
    }

    private org.apache.hadoop.conf.Configuration getHBaseConfiguration(Configuration conf) {
        org.apache.hadoop.conf.Configuration hbaseConf = null;
        try {
            org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)conf);
            hbaseConf = (org.apache.hadoop.conf.Configuration)Class.forName("org.apache.hadoop.hbase.HBaseConfiguration").getMethod("create", org.apache.hadoop.conf.Configuration.class).invoke(null, hadoopConf);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException e) {
            LOG.info("HBase is not available (not packaged with this application): {} : \"{}\".", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
        return hbaseConf;
    }

    public boolean delegationTokensRequired() throws Exception {
        if (this.hbaseConf == null) {
            LOG.debug("HBase is not available (not packaged with this application), hence no tokens will be acquired.");
            return false;
        }
        try {
            if (!HadoopUtils.isKerberosSecurityEnabled((UserGroupInformation)UserGroupInformation.getCurrentUser())) {
                return false;
            }
        }
        catch (IOException e) {
            LOG.debug("Hadoop Kerberos is not enabled.");
            return false;
        }
        return this.hbaseConf.get("hbase.security.authentication").equals("kerberos") && this.kerberosLoginProvider.isLoginPossible(false);
    }

    public DelegationTokenProvider.ObtainedDelegationTokens obtainDelegationTokens() throws Exception {
        UserGroupInformation freshUGI = this.kerberosLoginProvider.doLoginAndReturnUGI();
        return (DelegationTokenProvider.ObtainedDelegationTokens)freshUGI.doAs(() -> {
            Token token;
            block2: {
                Preconditions.checkNotNull((Object)this.hbaseConf);
                try {
                    LOG.info("Obtaining Kerberos security token for HBase");
                    token = (Token)Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil").getMethod("obtainToken", org.apache.hadoop.conf.Configuration.class).invoke(null, this.hbaseConf);
                }
                catch (NoSuchMethodException e) {
                    Closeable connectionFactory = (Closeable)Class.forName("org.apache.hadoop.hbase.client.ConnectionFactory").getMethod("createConnection", org.apache.hadoop.conf.Configuration.class).invoke(null, this.hbaseConf);
                    Class<?> connectionClass = Class.forName("org.apache.hadoop.hbase.client.Connection");
                    token = (Token)Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil").getMethod("obtainToken", connectionClass).invoke(null, connectionFactory);
                    if (null == connectionFactory) break block2;
                    connectionFactory.close();
                }
            }
            Credentials credentials = new Credentials();
            credentials.addToken(token.getService(), token);
            return new DelegationTokenProvider.ObtainedDelegationTokens(HadoopDelegationTokenConverter.serialize(credentials), Optional.empty());
        });
    }
}

