/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class JobExceptionsInfo {
    public static final String FIELD_NAME_ROOT_EXCEPTION = "root-exception";
    public static final String FIELD_NAME_TIMESTAMP = "timestamp";
    public static final String FIELD_NAME_ALL_EXCEPTIONS = "all-exceptions";
    public static final String FIELD_NAME_TRUNCATED = "truncated";
    @Deprecated
    @JsonProperty(value="root-exception")
    private final String rootException;
    @Deprecated
    @JsonProperty(value="timestamp")
    private final Long rootTimestamp;
    @Deprecated
    @JsonProperty(value="all-exceptions")
    private final List<ExecutionExceptionInfo> allExceptions;
    @Deprecated
    @JsonProperty(value="truncated")
    private final boolean truncated;

    @JsonCreator
    public JobExceptionsInfo(@JsonProperty(value="root-exception") String rootException, @JsonProperty(value="timestamp") Long rootTimestamp, @JsonProperty(value="all-exceptions") List<ExecutionExceptionInfo> allExceptions, @JsonProperty(value="truncated") boolean truncated) {
        this.rootException = rootException;
        this.rootTimestamp = rootTimestamp;
        this.allExceptions = (List)Preconditions.checkNotNull(allExceptions);
        this.truncated = truncated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobExceptionsInfo that = (JobExceptionsInfo)o;
        return this.truncated == that.truncated && Objects.equals(this.rootException, that.rootException) && Objects.equals(this.rootTimestamp, that.rootTimestamp) && Objects.equals(this.allExceptions, that.allExceptions);
    }

    public int hashCode() {
        return Objects.hash(this.rootException, this.rootTimestamp, this.allExceptions, this.truncated);
    }

    public String toString() {
        return new StringJoiner(", ", JobExceptionsInfo.class.getSimpleName() + "[", "]").add("rootException='" + this.rootException + "'").add("rootTimestamp=" + this.rootTimestamp).add("allExceptions=" + this.allExceptions).add("truncated=" + this.truncated).toString();
    }

    @JsonIgnore
    public String getRootException() {
        return this.rootException;
    }

    @JsonIgnore
    public Long getRootTimestamp() {
        return this.rootTimestamp;
    }

    @JsonIgnore
    public List<ExecutionExceptionInfo> getAllExceptions() {
        return this.allExceptions;
    }

    @JsonIgnore
    public boolean isTruncated() {
        return this.truncated;
    }

    @Deprecated
    public static final class ExecutionExceptionInfo {
        public static final String FIELD_NAME_EXCEPTION = "exception";
        public static final String FIELD_NAME_TASK = "task";
        public static final String FIELD_NAME_LOCATION = "location";
        public static final String FIELD_NAME_TIMESTAMP = "timestamp";
        public static final String FIELD_NAME_TASK_MANAGER_ID = "taskManagerId";
        @JsonProperty(value="exception")
        private final String exception;
        @JsonProperty(value="task")
        private final String task;
        @JsonProperty(value="location")
        private final String location;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonProperty(value="taskManagerId")
        private final String taskManagerId;

        @JsonCreator
        public ExecutionExceptionInfo(@JsonProperty(value="exception") String exception, @JsonProperty(value="task") String task, @JsonProperty(value="location") String location, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="taskManagerId") String taskManagerId) {
            this.exception = (String)Preconditions.checkNotNull((Object)exception);
            this.task = (String)Preconditions.checkNotNull((Object)task);
            this.location = (String)Preconditions.checkNotNull((Object)location);
            this.timestamp = timestamp;
            this.taskManagerId = taskManagerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionExceptionInfo that = (ExecutionExceptionInfo)o;
            return this.timestamp == that.timestamp && Objects.equals(this.exception, that.exception) && Objects.equals(this.task, that.task) && Objects.equals(this.location, that.location) && Objects.equals(this.taskManagerId, that.taskManagerId);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.exception, this.task, this.location, this.taskManagerId);
        }

        public String toString() {
            return new StringJoiner(", ", ExecutionExceptionInfo.class.getSimpleName() + "[", "]").add("exception='" + this.exception + "'").add("task='" + this.task + "'").add("location='" + this.location + "'").add("timestamp=" + this.timestamp).add("taskManagerId=" + this.taskManagerId).toString();
        }
    }
}

