/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testutils.ZooKeeperTestUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.flink.shaded.guava30.com.google.common.io.Closer;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperUtilsTreeCacheTest
extends TestLogger {
    private static final String PARENT_PATH = "/foo";
    private static final String CHILD_PATH = "/foo/bar";
    private Closer closer;
    private CuratorFramework client;
    private CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;
    private final AtomicReference<CompletableFuture<Void>> callbackFutureReference = new AtomicReference();

    @Before
    public void setUp() throws Exception {
        this.closer = Closer.create();
        TestingServer testingServer = (TestingServer)this.closer.register((Closeable)ZooKeeperTestUtils.createAndStartZookeeperTestingServer());
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)testingServer.getConnectString());
        this.curatorFrameworkWrapper = (CuratorFrameworkWithUnhandledErrorListener)this.closer.register((Closeable)ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE));
        this.client = this.curatorFrameworkWrapper.asCuratorFramework();
        TreeCache cache = (TreeCache)this.closer.register((Closeable)ZooKeeperUtils.createTreeCache((CuratorFramework)this.client, (String)CHILD_PATH, () -> this.callbackFutureReference.get().complete(null)));
        cache.start();
    }

    @After
    public void tearDown() throws Exception {
        this.closer.close();
        this.callbackFutureReference.set(null);
    }

    @Test
    public void testCallbackCalledOnNodeCreation() throws Exception {
        this.client.create().forPath(PARENT_PATH);
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.create().forPath(CHILD_PATH);
        this.callbackFutureReference.get().get();
    }

    @Test
    public void testCallbackCalledOnNodeModification() throws Exception {
        this.testCallbackCalledOnNodeCreation();
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.setData().forPath(CHILD_PATH, new byte[1]);
        this.callbackFutureReference.get().get();
    }

    @Test
    public void testCallbackCalledOnNodeDeletion() throws Exception {
        this.testCallbackCalledOnNodeCreation();
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.delete().forPath(CHILD_PATH);
        this.callbackFutureReference.get().get();
    }

    @Test
    public void testCallbackNotCalledOnCreationOfParents() throws Exception {
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.create().forPath(PARENT_PATH);
        MatcherAssert.assertThat(this.callbackFutureReference.get(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(20L)));
    }

    @Test
    public void testCallbackNotCalledOnCreationOfChildren() throws Exception {
        this.testCallbackCalledOnNodeCreation();
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.create().forPath("/foo/bar/baz");
        MatcherAssert.assertThat(this.callbackFutureReference.get(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(20L)));
    }

    @Test
    public void testCallbackNotCalledOnCreationOfSimilarPaths() throws Exception {
        this.callbackFutureReference.set(new CompletableFuture());
        this.client.create().creatingParentContainersIfNeeded().forPath(CHILD_PATH.substring(0, CHILD_PATH.length() - 1));
        MatcherAssert.assertThat(this.callbackFutureReference.get(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(20L)));
    }

    @Test
    public void testCallbackNotCalledOnConnectionOrInitializationEvents() throws Exception {
        TreeCacheListener treeCacheListener = ZooKeeperUtils.createTreeCacheListener(() -> {
            throw new AssertionError((Object)"Should not be called.");
        });
        treeCacheListener.childEvent(this.client, new TreeCacheEvent(TreeCacheEvent.Type.INITIALIZED, null));
        treeCacheListener.childEvent(this.client, new TreeCacheEvent(TreeCacheEvent.Type.CONNECTION_RECONNECTED, null));
        treeCacheListener.childEvent(this.client, new TreeCacheEvent(TreeCacheEvent.Type.CONNECTION_LOST, null));
        treeCacheListener.childEvent(this.client, new TreeCacheEvent(TreeCacheEvent.Type.CONNECTION_SUSPENDED, null));
    }
}

