/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TaskManagerLocationTest {
    TaskManagerLocationTest() {
    }

    @Test
    void testEqualsHashAndCompareTo() {
        try {
            ResourceID resourceID1 = new ResourceID("a");
            ResourceID resourceID2 = new ResourceID("b");
            ResourceID resourceID3 = new ResourceID("c");
            InetAddress address1 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address1.getCanonicalHostName()).thenReturn((Object)"localhost");
            Mockito.when((Object)address1.getHostName()).thenReturn((Object)"localhost");
            Mockito.when((Object)address1.getHostAddress()).thenReturn((Object)"127.0.0.1");
            Mockito.when((Object)address1.getAddress()).thenReturn((Object)new byte[]{127, 0, 0, 1});
            InetAddress address2 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address2.getCanonicalHostName()).thenReturn((Object)"testhost1");
            Mockito.when((Object)address2.getHostName()).thenReturn((Object)"testhost1");
            Mockito.when((Object)address2.getHostAddress()).thenReturn((Object)"0.0.0.0");
            Mockito.when((Object)address2.getAddress()).thenReturn((Object)new byte[]{0, 0, 0, 0});
            InetAddress address3 = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address3.getCanonicalHostName()).thenReturn((Object)"testhost2");
            Mockito.when((Object)address3.getHostName()).thenReturn((Object)"testhost2");
            Mockito.when((Object)address3.getHostAddress()).thenReturn((Object)"192.168.0.1");
            Mockito.when((Object)address3.getAddress()).thenReturn((Object)new byte[]{-64, -88, 0, 1});
            TaskManagerLocation one = new TaskManagerLocation(resourceID1, address1, 19871);
            TaskManagerLocation two = new TaskManagerLocation(resourceID2, address2, 19871);
            TaskManagerLocation three = new TaskManagerLocation(resourceID3, address3, 10871);
            TaskManagerLocation four = new TaskManagerLocation(resourceID1, address1, 19871);
            Assertions.assertThat((Comparable)one).isEqualTo((Object)four);
            Assertions.assertThat((Comparable)one).isNotEqualTo((Object)two);
            Assertions.assertThat((Comparable)one).isNotEqualTo((Object)three);
            Assertions.assertThat((Comparable)two).isNotEqualTo((Object)three);
            Assertions.assertThat((Comparable)three).isNotEqualTo((Object)four);
            Assertions.assertThat((int)one.compareTo(four)).isEqualTo(0);
            Assertions.assertThat((int)four.compareTo(one)).isEqualTo(0);
            Assertions.assertThat((int)one.compareTo(two)).isNotEqualTo(0);
            Assertions.assertThat((int)one.compareTo(three)).isNotEqualTo(0);
            Assertions.assertThat((int)two.compareTo(three)).isNotEqualTo(0);
            Assertions.assertThat((int)three.compareTo(four)).isNotEqualTo(0);
            int val = one.compareTo(two);
            Assertions.assertThat((int)two.compareTo(one)).isEqualTo(-val);
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testEqualsHashAndCompareToWithDifferentNodeId() throws Exception {
        ResourceID resourceID = ResourceID.generate();
        InetAddress inetAddress = InetAddress.getByName("1.2.3.4");
        TaskManagerLocation.DefaultHostNameSupplier hostNameSupplier = new TaskManagerLocation.DefaultHostNameSupplier(inetAddress);
        String nodeId1 = "node1";
        String nodeId2 = "node2";
        TaskManagerLocation one = new TaskManagerLocation(resourceID, inetAddress, 19871, (TaskManagerLocation.HostNameSupplier)hostNameSupplier, nodeId1);
        TaskManagerLocation two = new TaskManagerLocation(resourceID, inetAddress, 19871, (TaskManagerLocation.HostNameSupplier)hostNameSupplier, nodeId2);
        TaskManagerLocation three = new TaskManagerLocation(resourceID, inetAddress, 19871, (TaskManagerLocation.HostNameSupplier)hostNameSupplier, nodeId1);
        Assertions.assertThat((Comparable)one).isEqualTo((Object)three);
        Assertions.assertThat((Comparable)one).isNotEqualTo((Object)two);
        Assertions.assertThat((Comparable)two).isNotEqualTo((Object)three);
        Assertions.assertThat((int)one.hashCode()).isEqualTo(three.hashCode());
        Assertions.assertThat((int)one.hashCode()).isNotEqualTo(two.hashCode());
        Assertions.assertThat((int)two.hashCode()).isNotEqualTo(three.hashCode());
        Assertions.assertThat((int)one.compareTo(three)).isEqualTo(0);
        Assertions.assertThat((int)one.compareTo(two)).isNotEqualTo(0);
        Assertions.assertThat((int)two.compareTo(three)).isNotEqualTo(0);
        int val = one.compareTo(two);
        Assertions.assertThat((int)two.compareTo(one)).isEqualTo(-val);
    }

    @Test
    void testSerialization() {
        try {
            TaskManagerLocation original = new TaskManagerLocation(ResourceID.generate(), InetAddress.getByName("1.2.3.4"), 8888);
            TaskManagerLocation serCopy = (TaskManagerLocation)InstantiationUtil.clone((Serializable)original);
            Assertions.assertThat((Comparable)original).isEqualTo((Object)serCopy);
            original = new TaskManagerLocation(ResourceID.generate(), InetAddress.getByName("127.0.0.1"), 19871);
            original.getFQDNHostname();
            serCopy = (TaskManagerLocation)InstantiationUtil.clone((Serializable)original);
            Assertions.assertThat((Comparable)original).isEqualTo((Object)serCopy);
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGetFQDNHostname() {
        try {
            TaskManagerLocation info1 = new TaskManagerLocation(ResourceID.generate(), InetAddress.getByName("127.0.0.1"), 19871);
            Assertions.assertThat((String)info1.getFQDNHostname()).isNotNull();
            TaskManagerLocation info2 = new TaskManagerLocation(ResourceID.generate(), InetAddress.getByName("1.2.3.4"), 8888);
            Assertions.assertThat((String)info2.getFQDNHostname()).isNotNull();
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGetHostname0() {
        try {
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"worker2.cluster.mycompany.com");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"worker2.cluster.mycompany.com");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
            TaskManagerLocation info = new TaskManagerLocation(ResourceID.generate(), address, 19871);
            Assertions.assertThat((String)"worker2").isEqualTo(info.getHostname());
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGetHostname1() {
        try {
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"worker10");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"worker10");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
            TaskManagerLocation info = new TaskManagerLocation(ResourceID.generate(), address, 19871);
            Assertions.assertThat((String)"worker10").isEqualTo(info.getHostname());
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testGetHostname2() {
        try {
            String addressString = "192.168.254.254";
            InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
            Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getHostName()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"192.168.254.254");
            Mockito.when((Object)address.getAddress()).thenReturn((Object)new byte[]{-64, -88, -2, -2});
            TaskManagerLocation info = new TaskManagerLocation(ResourceID.generate(), address, 54152);
            Assertions.assertThat((String)info.getFQDNHostname()).isNotNull();
            Assertions.assertThat((String)info.getFQDNHostname()).isEqualTo("192.168.254.254");
            Assertions.assertThat((String)info.getHostname()).isNotNull();
            Assertions.assertThat((String)info.getHostname()).isEqualTo("192.168.254.254");
        }
        catch (Exception e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testNotRetrieveHostName() {
        InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)address.getCanonicalHostName()).thenReturn((Object)"worker10");
        Mockito.when((Object)address.getHostName()).thenReturn((Object)"worker10");
        Mockito.when((Object)address.getHostAddress()).thenReturn((Object)"127.0.0.1");
        TaskManagerLocation info = new TaskManagerLocation(ResourceID.generate(), address, 19871, (TaskManagerLocation.HostNameSupplier)new TaskManagerLocation.IpOnlyHostNameSupplier(address), address.getHostAddress());
        Assertions.assertThat((String)"worker10").isNotEqualTo((Object)info.getHostname());
        Assertions.assertThat((String)"worker10").isNotEqualTo((Object)info.getFQDNHostname());
        Assertions.assertThat((String)"127.0.0.1").isEqualTo(info.getHostname());
        Assertions.assertThat((String)"127.0.0.1").isEqualTo(info.getFQDNHostname());
    }
}

