/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rest.handler.InFlightRequestTracker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InFlightRequestTrackerTest {
    private InFlightRequestTracker inFlightRequestTracker;

    @Before
    public void setUp() {
        this.inFlightRequestTracker = new InFlightRequestTracker();
    }

    @Test
    public void testShouldFinishAwaitAsyncImmediatelyIfNoRequests() {
        Assert.assertTrue((boolean)this.inFlightRequestTracker.awaitAsync().isDone());
    }

    @Test
    public void testShouldFinishAwaitAsyncIffAllRequestsDeregistered() {
        this.inFlightRequestTracker.registerRequest();
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assert.assertFalse((boolean)awaitFuture.isDone());
        this.inFlightRequestTracker.deregisterRequest();
        Assert.assertTrue((boolean)awaitFuture.isDone());
    }

    @Test
    public void testAwaitAsyncIsIdempotent() {
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assert.assertTrue((boolean)awaitFuture.isDone());
        Assert.assertSame((String)"The reference to the future must not change", (Object)awaitFuture, (Object)this.inFlightRequestTracker.awaitAsync());
    }

    @Test
    public void testShouldTolerateRegisterAfterAwaitAsync() {
        CompletableFuture awaitFuture = this.inFlightRequestTracker.awaitAsync();
        Assert.assertTrue((boolean)awaitFuture.isDone());
        this.inFlightRequestTracker.registerRequest();
        Assert.assertSame((String)"The reference to the future must not change", (Object)awaitFuture, (Object)this.inFlightRequestTracker.awaitAsync());
    }

    @Test
    public void testShouldNotRegisterNewRequestsAfterTermination() {
        CompletableFuture terminationFuture = this.inFlightRequestTracker.awaitAsync();
        Assert.assertTrue((boolean)terminationFuture.isDone());
        Assert.assertFalse((boolean)this.inFlightRequestTracker.registerRequest());
    }
}

