/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.InternalRegionWriteReadUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class InternalRegionWriteReadUtilsTest {
    InternalRegionWriteReadUtilsTest() {
    }

    @Test
    void testAllocateAndConfigureBuffer() {
        int bufferSize = 16;
        ByteBuffer buffer = InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(16);
        Assertions.assertThat((int)buffer.limit()).isEqualTo(16);
        Assertions.assertThat((int)buffer.position()).isZero();
        Assertions.assertThat((boolean)buffer.isDirect()).isTrue();
        Assertions.assertThat((Object)buffer.order()).isEqualTo((Object)ByteOrder.nativeOrder());
    }

    @Test
    void testReadPrematureEndOfFile(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = InternalRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        InternalRegionWriteReadUtils.writeRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (HsFileDataIndexImpl.InternalRegion)HybridShuffleTestUtils.createSingleUnreleasedRegion(0, 0L, 1));
        channel.truncate(channel.position() - 1L);
        buffer.flip();
        Assertions.assertThatThrownBy(() -> InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L)).isInstanceOf(IOException.class);
    }

    @Test
    void testWriteAndReadRegion(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = InternalRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = InternalRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        HsFileDataIndexImpl.InternalRegion region = HybridShuffleTestUtils.createSingleUnreleasedRegion(10, 100L, 1);
        InternalRegionWriteReadUtils.writeRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (HsFileDataIndexImpl.InternalRegion)region);
        buffer.flip();
        HsFileDataIndexImpl.InternalRegion readRegion = InternalRegionWriteReadUtils.readRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
        HybridShuffleTestUtils.assertRegionEquals(readRegion, region);
    }

    private static FileChannel tmpFileChannel(Path tempPath) throws IOException {
        return FileChannel.open(Files.createFile(tempPath.resolve(UUID.randomUUID().toString()), new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }
}

