/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.HsBufferContext;
import org.apache.flink.runtime.io.network.partition.hybrid.HsConsumerId;
import org.apache.flink.runtime.io.network.partition.hybrid.HsMemoryDataManagerOperation;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSubpartitionConsumerMemoryDataManager;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.TestingMemoryDataManagerOperation;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class HsSubpartitionConsumerMemoryDataManagerTest {
    private static final int BUFFER_SIZE = 8;
    private static final int SUBPARTITION_ID = 0;

    HsSubpartitionConsumerMemoryDataManagerTest() {
    }

    @Test
    void testPeekNextToConsumeDataTypeNotMeetBufferIndexToConsume() throws Exception {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false));
        Assertions.assertThat((Comparable)subpartitionConsumerMemoryDataManager.peekNextToConsumeDataType(1)).isEqualTo((Object)Buffer.DataType.NONE);
    }

    @Test
    void testPeekNextToConsumeDataTypeTrimHeadingReleasedBuffers() throws Exception {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        HsBufferContext buffer1 = HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false);
        HsBufferContext buffer2 = HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(1, false);
        subpartitionConsumerMemoryDataManager.addBuffer(buffer1);
        subpartitionConsumerMemoryDataManager.addBuffer(buffer2);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(2, true));
        buffer1.release();
        buffer2.release();
        Assertions.assertThat((Comparable)subpartitionConsumerMemoryDataManager.peekNextToConsumeDataType(2)).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
    }

    @Test
    void testConsumeBufferFirstUnConsumedBufferIndexNotMeetNextToConsume() throws Exception {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false));
        Assertions.assertThat((Optional)subpartitionConsumerMemoryDataManager.consumeBuffer(1)).isNotPresent();
    }

    @Test
    void testConsumeBufferTrimHeadingReleasedBuffers() throws Exception {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        HsBufferContext buffer1 = HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false);
        HsBufferContext buffer2 = HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(1, false);
        subpartitionConsumerMemoryDataManager.addBuffer(buffer1);
        subpartitionConsumerMemoryDataManager.addBuffer(buffer2);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(2, true));
        buffer1.release();
        buffer2.release();
        Assertions.assertThat((Optional)subpartitionConsumerMemoryDataManager.consumeBuffer(2)).isPresent();
    }

    @Test
    void testConsumeBufferReturnSlice() {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false));
        Optional bufferOpt = subpartitionConsumerMemoryDataManager.consumeBuffer(0);
        Assertions.assertThat((Optional)bufferOpt).hasValueSatisfying(bufferAndBacklog -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)bufferAndBacklog.buffer()).isInstanceOf(ReadOnlySlicedNetworkBuffer.class);
        });
    }

    @Test
    void testAddBuffer() {
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().build();
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(memoryDataManagerOperation);
        ArrayDeque<HsBufferContext> initialBuffers = new ArrayDeque<HsBufferContext>();
        initialBuffers.add(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(0, false));
        initialBuffers.add(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(1, false));
        subpartitionConsumerMemoryDataManager.addInitialBuffers(initialBuffers);
        subpartitionConsumerMemoryDataManager.addBuffer(HsSubpartitionConsumerMemoryDataManagerTest.createBufferContext(2, true));
        Assertions.assertThat((Optional)subpartitionConsumerMemoryDataManager.consumeBuffer(0)).hasValueSatisfying(bufferAndBacklog -> {
            Assertions.assertThat((int)bufferAndBacklog.getSequenceNumber()).isEqualTo(0);
            Assertions.assertThat((Comparable)bufferAndBacklog.buffer().getDataType()).isEqualTo((Object)Buffer.DataType.DATA_BUFFER);
        });
        Assertions.assertThat((Optional)subpartitionConsumerMemoryDataManager.consumeBuffer(1)).hasValueSatisfying(bufferAndBacklog -> {
            Assertions.assertThat((int)bufferAndBacklog.getSequenceNumber()).isEqualTo(1);
            Assertions.assertThat((Comparable)bufferAndBacklog.buffer().getDataType()).isEqualTo((Object)Buffer.DataType.DATA_BUFFER);
        });
        Assertions.assertThat((Optional)subpartitionConsumerMemoryDataManager.consumeBuffer(2)).hasValueSatisfying(bufferAndBacklog -> {
            Assertions.assertThat((int)bufferAndBacklog.getSequenceNumber()).isEqualTo(2);
            Assertions.assertThat((Comparable)bufferAndBacklog.buffer().getDataType()).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
        });
    }

    @Test
    void testRelease() {
        CompletableFuture consumerReleasedFuture = new CompletableFuture();
        TestingMemoryDataManagerOperation memoryDataManagerOperation = TestingMemoryDataManagerOperation.builder().setOnConsumerReleasedBiConsumer((subpartitionId, consumerId) -> consumerReleasedFuture.complete(consumerId)).build();
        HsConsumerId consumerId2 = HsConsumerId.newId(null);
        HsSubpartitionConsumerMemoryDataManager subpartitionConsumerMemoryDataManager = this.createSubpartitionConsumerMemoryDataManager(consumerId2, memoryDataManagerOperation);
        subpartitionConsumerMemoryDataManager.releaseDataView();
        Assertions.assertThat(consumerReleasedFuture).isCompletedWithValue((Object)consumerId2);
    }

    private static HsBufferContext createBufferContext(int bufferIndex, boolean isEvent) {
        return new HsBufferContext(HybridShuffleTestUtils.createBuffer(8, isEvent), bufferIndex, 0);
    }

    private HsSubpartitionConsumerMemoryDataManager createSubpartitionConsumerMemoryDataManager(HsMemoryDataManagerOperation memoryDataManagerOperation) {
        return this.createSubpartitionConsumerMemoryDataManager(HsConsumerId.DEFAULT, memoryDataManagerOperation);
    }

    private HsSubpartitionConsumerMemoryDataManager createSubpartitionConsumerMemoryDataManager(HsConsumerId consumerId, HsMemoryDataManagerOperation memoryDataManagerOperation) {
        return new HsSubpartitionConsumerMemoryDataManager((Lock)new ReentrantLock(), (Lock)new ReentrantLock(), 0, consumerId, memoryDataManagerOperation);
    }
}

