/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedJobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingHighAvailabilityServices
implements HighAvailabilityServices {
    private volatile LeaderRetrievalService resourceManagerLeaderRetriever;
    private volatile LeaderRetrievalService dispatcherLeaderRetriever;
    private volatile LeaderRetrievalService clusterRestEndpointLeaderRetriever;
    private volatile Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction = ignored -> null;
    private volatile Function<JobID, LeaderElectionService> jobMasterLeaderElectionServiceFunction = ignored -> null;
    private ConcurrentHashMap<JobID, LeaderRetrievalService> jobMasterLeaderRetrievers = new ConcurrentHashMap();
    private ConcurrentHashMap<JobID, LeaderElectionService> jobManagerLeaderElectionServices = new ConcurrentHashMap();
    private volatile LeaderElectionService resourceManagerLeaderElectionService;
    private volatile LeaderElectionService dispatcherLeaderElectionService;
    private volatile LeaderElectionService clusterRestEndpointLeaderElectionService;
    private volatile CheckpointRecoveryFactory checkpointRecoveryFactory;
    private volatile JobGraphStore jobGraphStore;
    private volatile JobResultStore jobResultStore = new EmbeddedJobResultStore();
    private CompletableFuture<Void> closeFuture = new CompletableFuture();
    private CompletableFuture<Void> closeAndCleanupAllDataFuture = new CompletableFuture();
    private volatile CompletableFuture<JobID> globalCleanupFuture;

    public void setResourceManagerLeaderRetriever(LeaderRetrievalService resourceManagerLeaderRetriever) {
        this.resourceManagerLeaderRetriever = resourceManagerLeaderRetriever;
    }

    public void setDispatcherLeaderRetriever(LeaderRetrievalService dispatcherLeaderRetriever) {
        this.dispatcherLeaderRetriever = dispatcherLeaderRetriever;
    }

    public void setClusterRestEndpointLeaderRetriever(LeaderRetrievalService clusterRestEndpointLeaderRetriever) {
        this.clusterRestEndpointLeaderRetriever = clusterRestEndpointLeaderRetriever;
    }

    public void setJobMasterLeaderRetriever(JobID jobID, LeaderRetrievalService jobMasterLeaderRetriever) {
        this.jobMasterLeaderRetrievers.put(jobID, jobMasterLeaderRetriever);
    }

    public void setJobMasterLeaderElectionService(JobID jobID, LeaderElectionService leaderElectionService) {
        this.jobManagerLeaderElectionServices.put(jobID, leaderElectionService);
    }

    public void setResourceManagerLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.resourceManagerLeaderElectionService = leaderElectionService;
    }

    public void setDispatcherLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.dispatcherLeaderElectionService = leaderElectionService;
    }

    public void setClusterRestEndpointLeaderElectionService(LeaderElectionService clusterRestEndpointLeaderElectionService) {
        this.clusterRestEndpointLeaderElectionService = clusterRestEndpointLeaderElectionService;
    }

    public void setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
    }

    public void setJobGraphStore(JobGraphStore jobGraphStore) {
        this.jobGraphStore = jobGraphStore;
    }

    public void setJobResultStore(JobResultStore jobResultStore) {
        this.jobResultStore = jobResultStore;
    }

    public void setJobMasterLeaderElectionServiceFunction(Function<JobID, LeaderElectionService> jobMasterLeaderElectionServiceFunction) {
        this.jobMasterLeaderElectionServiceFunction = jobMasterLeaderElectionServiceFunction;
    }

    public void setJobMasterLeaderRetrieverFunction(Function<JobID, LeaderRetrievalService> jobMasterLeaderRetrieverFunction) {
        this.jobMasterLeaderRetrieverFunction = jobMasterLeaderRetrieverFunction;
    }

    public void setCloseFuture(CompletableFuture<Void> closeFuture) {
        this.closeFuture = closeFuture;
    }

    public void setCloseAndCleanupAllDataFuture(CompletableFuture<Void> closeAndCleanupAllDataFuture) {
        this.closeAndCleanupAllDataFuture = closeAndCleanupAllDataFuture;
    }

    public void setGlobalCleanupFuture(CompletableFuture<JobID> globalCleanupFuture) {
        this.globalCleanupFuture = globalCleanupFuture;
    }

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        LeaderRetrievalService service = this.resourceManagerLeaderRetriever;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        LeaderRetrievalService service = this.dispatcherLeaderRetriever;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        LeaderRetrievalService service = this.jobMasterLeaderRetrievers.computeIfAbsent(jobID, this.jobMasterLeaderRetrieverFunction);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return this.clusterRestEndpointLeaderRetriever;
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        LeaderElectionService service = this.resourceManagerLeaderElectionService;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderElectionService has not been set");
    }

    public LeaderElectionService getDispatcherLeaderElectionService() {
        LeaderElectionService service = this.dispatcherLeaderElectionService;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("DispatcherLeaderElectionService has not been set");
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        LeaderElectionService service = this.jobManagerLeaderElectionServices.computeIfAbsent(jobID, this.jobMasterLeaderElectionServiceFunction);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderElectionService has not been set");
    }

    public LeaderElectionService getClusterRestEndpointLeaderElectionService() {
        return this.clusterRestEndpointLeaderElectionService;
    }

    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        CheckpointRecoveryFactory factory = this.checkpointRecoveryFactory;
        if (factory != null) {
            return factory;
        }
        throw new IllegalStateException("CheckpointRecoveryFactory has not been set");
    }

    public JobGraphStore getJobGraphStore() {
        JobGraphStore store = this.jobGraphStore;
        if (store != null) {
            return store;
        }
        throw new IllegalStateException("JobGraphStore has not been set");
    }

    public JobResultStore getJobResultStore() {
        return this.jobResultStore;
    }

    public BlobStore createBlobStore() throws IOException {
        return new VoidBlobStore();
    }

    public void close() throws Exception {
        this.closeFuture.complete(null);
    }

    public void closeAndCleanupAllData() throws Exception {
        this.closeAndCleanupAllDataFuture.complete(null);
    }

    public CompletableFuture<Void> globalCleanupAsync(JobID jobID, Executor executor) {
        if (this.globalCleanupFuture != null) {
            this.globalCleanupFuture.complete(jobID);
        }
        return FutureUtils.completedVoidFuture();
    }
}

