/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class ManualLeaderService {
    private final List<TestingLeaderElectionService> leaderElectionServices = new ArrayList<TestingLeaderElectionService>(4);
    private final List<SettableLeaderRetrievalService> leaderRetrievalServices = new ArrayList<SettableLeaderRetrievalService>(4);
    private int currentLeaderIndex = -1;
    @Nullable
    private UUID currentLeaderId = null;

    public LeaderRetrievalService createLeaderRetrievalService() {
        SettableLeaderRetrievalService settableLeaderRetrievalService = new SettableLeaderRetrievalService(this.getLeaderAddress(this.currentLeaderIndex), this.currentLeaderId);
        this.leaderRetrievalServices.add(settableLeaderRetrievalService);
        return settableLeaderRetrievalService;
    }

    public LeaderElectionService createLeaderElectionService() {
        TestingLeaderElectionService testingLeaderElectionService = new TestingLeaderElectionService();
        this.leaderElectionServices.add(testingLeaderElectionService);
        return testingLeaderElectionService;
    }

    public void grantLeadership(int index, UUID leaderId) {
        if (this.currentLeaderId != null) {
            this.revokeLeadership();
        }
        Preconditions.checkNotNull((Object)leaderId);
        Preconditions.checkArgument((0 <= index && index < this.leaderElectionServices.size() ? 1 : 0) != 0);
        TestingLeaderElectionService testingLeaderElectionService = this.leaderElectionServices.get(index);
        testingLeaderElectionService.isLeader(leaderId);
        this.currentLeaderIndex = index;
        this.currentLeaderId = leaderId;
    }

    public void revokeLeadership() {
        Preconditions.checkState((this.currentLeaderId != null ? 1 : 0) != 0);
        Preconditions.checkState((0 <= this.currentLeaderIndex && this.currentLeaderIndex < this.leaderElectionServices.size() ? 1 : 0) != 0);
        TestingLeaderElectionService testingLeaderElectionService = this.leaderElectionServices.get(this.currentLeaderIndex);
        testingLeaderElectionService.notLeader();
        this.currentLeaderIndex = -1;
        this.currentLeaderId = null;
    }

    public void notifyRetrievers(int index, UUID leaderId) {
        for (SettableLeaderRetrievalService retrievalService : this.leaderRetrievalServices) {
            retrievalService.notifyListener(this.getLeaderAddress(index), leaderId);
        }
    }

    private String getLeaderAddress(int index) {
        if (0 <= index && index < this.leaderElectionServices.size()) {
            TestingLeaderElectionService testingLeaderElectionService = this.leaderElectionServices.get(index);
            return testingLeaderElectionService.getAddress();
        }
        return null;
    }
}

