/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.highavailability.FileSystemJobResultStore;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.highavailability.JobResultStoreContractTest;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@ExtendWith(value={TestLoggerExtension.class})
public class FileSystemJobResultStoreFileOperationsTest {
    private static final ObjectMapper MAPPER = JacksonMapperFactory.createObjectMapper();
    private FileSystemJobResultStore fileSystemJobResultStore;
    @TempDir
    File temporaryFolder;
    private Path basePath;

    @BeforeEach
    public void setupTest() throws IOException {
        this.basePath = new Path(this.temporaryFolder.toURI());
        this.fileSystemJobResultStore = new FileSystemJobResultStore(this.basePath.getFileSystem(), this.basePath, false);
    }

    @Test
    public void testValidEntryPathCreation() {
        Path entryParent = this.fileSystemJobResultStore.constructEntryPath("random-name").getParent();
        Assertions.assertThat((Object)entryParent).extracting(FileSystemJobResultStoreFileOperationsTest::stripSucceedingSlash).isEqualTo((Object)FileSystemJobResultStoreFileOperationsTest.stripSucceedingSlash(this.basePath));
    }

    private static String stripSucceedingSlash(Path path) {
        String uriStr = path.toUri().toString();
        if (uriStr.charAt(uriStr.length() - 1) == '/') {
            return uriStr.substring(0, uriStr.length() - 1);
        }
        return uriStr;
    }

    @Test
    public void testHasValidJobResultStoreEntryExtension() {
        Assertions.assertThat((boolean)FileSystemJobResultStore.hasValidJobResultStoreEntryExtension((String)"test.json")).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"test.txt", "", "test.zip"})
    public void testHasInvalidJobResultStoreEntryExtension(String filename) {
        Assertions.assertThat((boolean)FileSystemJobResultStore.hasValidJobResultStoreEntryExtension((String)filename)).isFalse();
    }

    @Test
    public void testHasValidDirtyJobResultStoreEntryExtension() {
        Assertions.assertThat((boolean)FileSystemJobResultStore.hasValidDirtyJobResultStoreEntryExtension((String)"test_DIRTY.json")).isTrue();
    }

    @ParameterizedTest
    @ValueSource(strings={"test.json", "test.txt", "", "test.zip"})
    public void testHasInvalidDirtyJobResultStoreEntryExtension(String filename) {
        Assertions.assertThat((boolean)FileSystemJobResultStore.hasValidDirtyJobResultStoreEntryExtension((String)filename)).isFalse();
    }

    @Test
    public void testBaseDirectoryCreationOnResultStoreInitialization() throws Exception {
        File emptyBaseDirectory = new File(this.temporaryFolder.getPath(), "empty-temp-dir");
        Path basePath = new Path(emptyBaseDirectory.getPath());
        Assertions.assertThat((File)emptyBaseDirectory).doesNotExist();
        this.fileSystemJobResultStore = new FileSystemJobResultStore(basePath.getFileSystem(), basePath, false);
        Assertions.assertThat((File)emptyBaseDirectory).exists().isDirectory();
    }

    @Test
    public void testStoreDirtyJobResultCreatesFile() throws Exception {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        Assertions.assertThat(this.getCleanResultIdsFromFileSystem()).isEmpty();
        Assertions.assertThat((File)this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).exists().isFile().isNotEmpty();
    }

    @Test
    public void testStoreCleanJobResultCreatesFile() throws Exception {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        this.fileSystemJobResultStore.markResultAsClean(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThat(this.getCleanResultIdsFromFileSystem()).containsExactlyInAnyOrder((Object[])new JobID[]{JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId()});
    }

    @Test
    public void testStoreCleanJobResultDeletesDirtyFile() throws Exception {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        Assertions.assertThat((File)this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).exists().isFile().isNotEmpty();
        this.fileSystemJobResultStore.markResultAsClean(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThat((File)this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).doesNotExist();
    }

    @Test
    public void testCleanDirtyJobResultTwiceIsIdempotent() throws IOException {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        this.fileSystemJobResultStore.markResultAsClean(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        byte[] cleanFileData = FileUtils.readAllBytes((java.nio.file.Path)this.expectedCleanFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY).toPath());
        this.fileSystemJobResultStore.markResultAsClean(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        ((AbstractFileAssert)Assertions.assertThat((File)this.expectedCleanFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).as("Marking the same job %s as clean should be idempotent.", new Object[]{JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId()})).hasBinaryContent(cleanFileData);
    }

    @Test
    public void testDeleteOnCommit() throws IOException {
        Path path = new Path(this.temporaryFolder.toURI());
        this.fileSystemJobResultStore = new FileSystemJobResultStore(path.getFileSystem(), path, true);
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        Assertions.assertThat((File)this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).exists().isFile().isNotEmpty();
        this.fileSystemJobResultStore.markResultAsClean(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThat((File)this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).doesNotExist();
        Assertions.assertThat((File)this.expectedCleanFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY)).doesNotExist();
    }

    @Test
    public void testVersionSerialization() throws IOException {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        File dirtyFile = this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        FileSystemJobResultStore.JsonJobResultEntry deserializedEntry = (FileSystemJobResultStore.JsonJobResultEntry)MAPPER.readValue(dirtyFile, FileSystemJobResultStore.JsonJobResultEntry.class);
        Assertions.assertThat((File)dirtyFile).isFile().content().containsPattern((CharSequence)"\"version\":1");
        Assertions.assertThat((int)deserializedEntry.getVersion()).isEqualTo(1);
    }

    @Test
    public void testJobResultSerializationDeserialization() throws IOException {
        this.fileSystemJobResultStore.createDirtyResult(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        File dirtyFile = this.expectedDirtyFile(JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY);
        FileSystemJobResultStore.JsonJobResultEntry deserializedEntry = (FileSystemJobResultStore.JsonJobResultEntry)MAPPER.readValue(dirtyFile, FileSystemJobResultStore.JsonJobResultEntry.class);
        JobResult deserializedJobResult = deserializedEntry.getJobResult();
        Assertions.assertThat((Object)deserializedJobResult).extracting(JobResult::getJobId).isEqualTo((Object)JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobId());
        Assertions.assertThat((Object)deserializedJobResult).extracting(JobResult::getApplicationStatus).isEqualTo((Object)JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobResult().getApplicationStatus());
        Assertions.assertThat((Object)deserializedJobResult).extracting(JobResult::getNetRuntime).isEqualTo((Object)JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobResult().getNetRuntime());
        Assertions.assertThat((Object)deserializedJobResult).extracting(JobResult::getSerializedThrowable).isEqualTo((Object)JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobResult().getSerializedThrowable());
        Assertions.assertThat((Object)deserializedJobResult).extracting(JobResult::getAccumulatorResults).isEqualTo((Object)JobResultStoreContractTest.DUMMY_JOB_RESULT_ENTRY.getJobResult().getAccumulatorResults());
    }

    private List<JobID> getCleanResultIdsFromFileSystem() throws IOException {
        ArrayList<JobID> cleanResults = new ArrayList<JobID>();
        File[] cleanFiles = this.temporaryFolder.listFiles((dir, name) -> !FileSystemJobResultStore.hasValidDirtyJobResultStoreEntryExtension((String)name));
        assert (cleanFiles != null);
        for (File cleanFile : cleanFiles) {
            FileSystemJobResultStore.JsonJobResultEntry entry = (FileSystemJobResultStore.JsonJobResultEntry)MAPPER.readValue(cleanFile, FileSystemJobResultStore.JsonJobResultEntry.class);
            cleanResults.add(entry.getJobResult().getJobId());
        }
        return cleanResults;
    }

    private File expectedDirtyFile(JobResultEntry entry) {
        return new File(this.temporaryFolder.toURI().getPath(), entry.getJobId().toString() + "_DIRTY.json");
    }

    private File expectedCleanFile(JobResultEntry entry) {
        return new File(this.temporaryFolder.toURI().getPath(), entry.getJobId().toString() + ".json");
    }
}

