/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collection;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionHistoryTest {
    ExecutionHistoryTest() {
    }

    @Test
    void testSizeLimit() {
        ExecutionHistory history = new ExecutionHistory(2);
        ExecutionVertexID executionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        history.add(ExecutionHistoryTest.createArchivedExecution(ExecutionGraphTestUtils.createExecutionAttemptId(executionVertexId, 0)));
        history.add(ExecutionHistoryTest.createArchivedExecution(ExecutionGraphTestUtils.createExecutionAttemptId(executionVertexId, 1)));
        history.add(ExecutionHistoryTest.createArchivedExecution(ExecutionGraphTestUtils.createExecutionAttemptId(executionVertexId, 2)));
        Assertions.assertThat((Collection)history.getHistoricalExecutions()).hasSize(2);
        Assertions.assertThat((boolean)history.getHistoricalExecution(0).isPresent()).isFalse();
        Assertions.assertThat((boolean)history.getHistoricalExecution(1).isPresent()).isTrue();
        Assertions.assertThat((boolean)history.getHistoricalExecution(2).isPresent()).isTrue();
    }

    @Test
    void testValidateAttemptNumber() {
        ExecutionHistory history = new ExecutionHistory(2);
        ExecutionVertexID executionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        history.add(ExecutionHistoryTest.createArchivedExecution(ExecutionGraphTestUtils.createExecutionAttemptId(executionVertexId, 3)));
        Assertions.assertThat((boolean)history.isValidAttemptNumber(2)).isTrue();
        Assertions.assertThat((boolean)history.isValidAttemptNumber(3)).isTrue();
        Assertions.assertThat((boolean)history.isValidAttemptNumber(4)).isFalse();
    }

    @Test
    void testGetWithInvalidAttemptNumber() {
        ExecutionHistory history = new ExecutionHistory(2);
        ExecutionVertexID executionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        history.add(ExecutionHistoryTest.createArchivedExecution(ExecutionGraphTestUtils.createExecutionAttemptId(executionVertexId, 3)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> history.getHistoricalExecution(4)).as("IllegalArgumentException should happen", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    private static ArchivedExecution createArchivedExecution(ExecutionAttemptID attemptId) {
        return new ArchivedExecution(new StringifiedAccumulatorResult[0], null, attemptId, ExecutionState.CANCELED, null, null, null, new long[ExecutionState.values().length], new long[ExecutionState.values().length]);
    }
}

