/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStoreTestUtils;
import org.apache.flink.runtime.dispatcher.FileExecutionGraphInfoStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava30.com.google.common.cache.LoadingCache;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileExecutionGraphInfoStoreTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testPut() throws IOException {
        this.assertPutJobGraphWithStatus(JobStatus.FINISHED);
    }

    @Test
    public void testPutSuspendedJob() throws IOException {
        this.assertPutJobGraphWithStatus(JobStatus.SUSPENDED);
    }

    @Test
    public void testUnknownGet() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        try (FileExecutionGraphInfoStore executionGraphStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            Assert.assertThat((Object)executionGraphStore.get(new JobID()), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testStoredJobsOverview() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> executionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        List jobStatuses = executionGraphInfos.stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        JobsOverview expectedJobsOverview = JobsOverview.create(jobStatuses);
        File rootDir = temporaryFolder.newFolder();
        try (FileExecutionGraphInfoStore executionGraphInfoStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            for (ExecutionGraphInfo executionGraphInfo : executionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
            }
            Assert.assertThat((Object)executionGraphInfoStore.getStoredJobsOverview(), (Matcher)Matchers.equalTo((Object)expectedJobsOverview));
        }
    }

    @Test
    public void testAvailableJobDetails() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> executionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<JobDetails> jobDetails = ExecutionGraphInfoStoreTestUtils.generateJobDetails(executionGraphInfos);
        File rootDir = temporaryFolder.newFolder();
        try (FileExecutionGraphInfoStore executionGraphInfoStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            for (ExecutionGraphInfo executionGraphInfo : executionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
            }
            Assert.assertThat((Object)executionGraphInfoStore.getAvailableJobDetails(), (Matcher)Matchers.containsInAnyOrder((Object[])jobDetails.toArray()));
        }
    }

    @Test
    public void testExecutionGraphExpiration() throws Exception {
        File rootDir = temporaryFolder.newFolder();
        Time expirationTime = Time.milliseconds((long)1L);
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManualTicker manualTicker = new ManualTicker();
        try (FileExecutionGraphInfoStore executionGraphInfoStore = new FileExecutionGraphInfoStore(rootDir, expirationTime, Integer.MAX_VALUE, 10000L, (ScheduledExecutor)scheduledExecutor, (Ticker)manualTicker);){
            ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build());
            executionGraphInfoStore.put(executionGraphInfo);
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)1));
            manualTicker.advanceTime(expirationTime.toMilliseconds(), TimeUnit.MILLISECONDS);
            scheduledExecutor.triggerScheduledTasks();
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)executionGraphInfoStore.get(executionGraphInfo.getJobId()), (Matcher)Matchers.nullValue());
            File storageDirectory = executionGraphInfoStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void testCloseCleansUp() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
        try (FileExecutionGraphInfoStore executionGraphInfoStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
            File storageDirectory = executionGraphInfoStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
            executionGraphInfoStore.put(new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build()));
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
        }
        Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testCacheLoading() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        try (FileExecutionGraphInfoStore executionGraphInfoStore = new FileExecutionGraphInfoStore(rootDir, Time.hours((long)1L), Integer.MAX_VALUE, 102400L, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()), Ticker.systemTicker());){
            LoadingCache executionGraphInfoCache = executionGraphInfoStore.getExecutionGraphInfoCache();
            ArrayList<ExecutionGraphInfo> executionGraphInfos = new ArrayList<ExecutionGraphInfo>(64);
            boolean continueInserting = true;
            while (continueInserting) {
                ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build());
                executionGraphInfoStore.put(executionGraphInfo);
                executionGraphInfos.add(executionGraphInfo);
                continueInserting = executionGraphInfoCache.size() == (long)executionGraphInfos.size();
            }
            File storageDirectory = executionGraphInfoStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)executionGraphInfos.size()));
            for (ExecutionGraphInfo executionGraphInfo : executionGraphInfos) {
                Assert.assertThat((Object)executionGraphInfoStore.get(executionGraphInfo.getJobId()), FileExecutionGraphInfoStoreTest.matchesPartiallyWith(executionGraphInfo));
            }
        }
    }

    @Test
    public void testMaximumCapacity() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        int maxCapacity = 10;
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> oldExecutionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<ExecutionGraphInfo> newExecutionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<JobDetails> jobDetails = ExecutionGraphInfoStoreTestUtils.generateJobDetails(newExecutionGraphInfos);
        try (FileExecutionGraphInfoStore executionGraphInfoStore = new FileExecutionGraphInfoStore(rootDir, Time.hours((long)1L), 10, 10000L, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()), Ticker.systemTicker());){
            for (ExecutionGraphInfo executionGraphInfo : oldExecutionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
                Assert.assertTrue((executionGraphInfoStore.size() <= 10 ? 1 : 0) != 0);
            }
            for (ExecutionGraphInfo executionGraphInfo : newExecutionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
                Assert.assertEquals((long)10L, (long)executionGraphInfoStore.size());
            }
            Assert.assertThat((Object)executionGraphInfoStore.getAvailableJobDetails(), (Matcher)Matchers.containsInAnyOrder((Object[])jobDetails.toArray()));
        }
    }

    @Test
    public void testPutSuspendedJobOnClusterShutdown() throws Exception {
        File rootDir = temporaryFolder.newFolder();
        try (ExecutionGraphInfoStoreTestUtils.PersistingMiniCluster miniCluster = new ExecutionGraphInfoStoreTestUtils.PersistingMiniCluster(new MiniClusterConfiguration.Builder().withRandomPorts().build(), rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            miniCluster.start();
            JobVertex vertex = new JobVertex("blockingVertex");
            vertex.setParallelism(1);
            vertex.setInvokableClass(ExecutionGraphInfoStoreTestUtils.SignallingBlockingNoOpInvokable.class);
            JobGraph jobGraph = JobGraphTestUtils.streamingJobGraph(vertex);
            miniCluster.submitJob(jobGraph);
            ExecutionGraphInfoStoreTestUtils.SignallingBlockingNoOpInvokable.LATCH.await();
        }
    }

    private void assertPutJobGraphWithStatus(JobStatus jobStatus) throws IOException {
        ExecutionGraphInfo dummyExecutionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(jobStatus).build());
        File rootDir = temporaryFolder.newFolder();
        try (FileExecutionGraphInfoStore executionGraphStore = ExecutionGraphInfoStoreTestUtils.createDefaultExecutionGraphInfoStore(rootDir, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            File storageDirectory = executionGraphStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
            executionGraphStore.put(dummyExecutionGraphInfo);
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)executionGraphStore.get(dummyExecutionGraphInfo.getJobId()), (Matcher)new ExecutionGraphInfoStoreTestUtils.PartialExecutionGraphInfoMatcher(dummyExecutionGraphInfo));
        }
    }

    private static Matcher<ExecutionGraphInfo> matchesPartiallyWith(ExecutionGraphInfo executionGraphInfo) {
        return new ExecutionGraphInfoStoreTestUtils.PartialExecutionGraphInfoMatcher(executionGraphInfo);
    }
}

