/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UserCodeClassLoader;

public class RuntimeEnvironment
implements Environment {
    private final JobID jobId;
    private final JobVertexID jobVertexId;
    private final ExecutionAttemptID executionId;
    private final TaskInfo taskInfo;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final ExecutionConfig executionConfig;
    private final UserCodeClassLoader userCodeClassLoader;
    private final MemoryManager memManager;
    private final SharedResources sharedResources;
    private final IOManager ioManager;
    private final BroadcastVariableManager bcVarManager;
    private final TaskStateManager taskStateManager;
    private final GlobalAggregateManager aggregateManager;
    private final InputSplitProvider splitProvider;
    private final ExternalResourceInfoProvider externalResourceInfoProvider;
    private final Map<String, Future<Path>> distCacheEntries;
    private final ResultPartitionWriter[] writers;
    private final IndexedInputGate[] inputGates;
    private final TaskEventDispatcher taskEventDispatcher;
    private final CheckpointResponder checkpointResponder;
    private final TaskOperatorEventGateway operatorEventGateway;
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry kvStateRegistry;
    private final TaskManagerRuntimeInfo taskManagerInfo;
    private final TaskMetricGroup metrics;
    private final Task containingTask;
    @Nullable
    private MailboxExecutor mainMailboxExecutor;
    @Nullable
    private ExecutorService asyncOperationsThreadPool;
    @Nullable
    private CheckpointStorageAccess checkpointStorageAccess;
    ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory;

    public RuntimeEnvironment(JobID jobId, JobVertexID jobVertexId, ExecutionAttemptID executionId, ExecutionConfig executionConfig, TaskInfo taskInfo, Configuration jobConfiguration, Configuration taskConfiguration, UserCodeClassLoader userCodeClassLoader, MemoryManager memManager, SharedResources sharedResources, IOManager ioManager, BroadcastVariableManager bcVarManager, TaskStateManager taskStateManager, GlobalAggregateManager aggregateManager, AccumulatorRegistry accumulatorRegistry, TaskKvStateRegistry kvStateRegistry, InputSplitProvider splitProvider, Map<String, Future<Path>> distCacheEntries, ResultPartitionWriter[] writers, IndexedInputGate[] inputGates, TaskEventDispatcher taskEventDispatcher, CheckpointResponder checkpointResponder, TaskOperatorEventGateway operatorEventGateway, TaskManagerRuntimeInfo taskManagerInfo, TaskMetricGroup metrics, Task containingTask, ExternalResourceInfoProvider externalResourceInfoProvider, ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobVertexId = (JobVertexID)Preconditions.checkNotNull((Object)jobVertexId);
        this.executionId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionId);
        this.taskInfo = (TaskInfo)Preconditions.checkNotNull((Object)taskInfo);
        this.executionConfig = (ExecutionConfig)Preconditions.checkNotNull((Object)executionConfig);
        this.jobConfiguration = (Configuration)Preconditions.checkNotNull((Object)jobConfiguration);
        this.taskConfiguration = (Configuration)Preconditions.checkNotNull((Object)taskConfiguration);
        this.userCodeClassLoader = (UserCodeClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.memManager = (MemoryManager)Preconditions.checkNotNull((Object)memManager);
        this.sharedResources = (SharedResources)Preconditions.checkNotNull((Object)sharedResources);
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.bcVarManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)bcVarManager);
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.aggregateManager = (GlobalAggregateManager)Preconditions.checkNotNull((Object)aggregateManager);
        this.accumulatorRegistry = (AccumulatorRegistry)Preconditions.checkNotNull((Object)accumulatorRegistry);
        this.kvStateRegistry = (TaskKvStateRegistry)Preconditions.checkNotNull((Object)kvStateRegistry);
        this.splitProvider = (InputSplitProvider)Preconditions.checkNotNull((Object)splitProvider);
        this.distCacheEntries = (Map)Preconditions.checkNotNull(distCacheEntries);
        this.writers = (ResultPartitionWriter[])Preconditions.checkNotNull((Object)writers);
        this.inputGates = (IndexedInputGate[])Preconditions.checkNotNull((Object)inputGates);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        this.operatorEventGateway = (TaskOperatorEventGateway)Preconditions.checkNotNull((Object)operatorEventGateway);
        this.taskManagerInfo = (TaskManagerRuntimeInfo)Preconditions.checkNotNull((Object)taskManagerInfo);
        this.containingTask = containingTask;
        this.metrics = metrics;
        this.externalResourceInfoProvider = (ExternalResourceInfoProvider)Preconditions.checkNotNull((Object)externalResourceInfoProvider);
        this.channelStateExecutorFactory = (ChannelStateWriteRequestExecutorFactory)Preconditions.checkNotNull((Object)channelStateExecutorFactory);
    }

    @Override
    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    @Override
    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    @Override
    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    @Override
    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    @Override
    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    @Override
    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerInfo;
    }

    @Override
    public TaskMetricGroup getMetricGroup() {
        return this.metrics;
    }

    @Override
    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    @Override
    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    @Override
    public IOManager getIOManager() {
        return this.ioManager;
    }

    @Override
    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    @Override
    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    @Override
    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.aggregateManager;
    }

    @Override
    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    @Override
    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry;
    }

    @Override
    public InputSplitProvider getInputSplitProvider() {
        return this.splitProvider;
    }

    @Override
    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return this.distCacheEntries;
    }

    @Override
    public ResultPartitionWriter getWriter(int index) {
        return this.writers[index];
    }

    @Override
    public ResultPartitionWriter[] getAllWriters() {
        return this.writers;
    }

    @Override
    public IndexedInputGate getInputGate(int index) {
        return this.inputGates[index];
    }

    @Override
    public IndexedInputGate[] getAllInputGates() {
        return this.inputGates;
    }

    @Override
    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    @Override
    public ExternalResourceInfoProvider getExternalResourceInfoProvider() {
        return this.externalResourceInfoProvider;
    }

    @Override
    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
        this.acknowledgeCheckpoint(checkpointId, checkpointMetrics, null);
    }

    @Override
    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot checkpointStateHandles) {
        this.checkpointResponder.acknowledgeCheckpoint(this.jobId, this.executionId, checkpointId, checkpointMetrics, checkpointStateHandles);
    }

    @Override
    public void declineCheckpoint(long checkpointId, CheckpointException checkpointException) {
        this.checkpointResponder.declineCheckpoint(this.jobId, this.executionId, checkpointId, checkpointException);
    }

    @Override
    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway() {
        return this.operatorEventGateway;
    }

    @Override
    public void failExternally(Throwable cause) {
        this.containingTask.failExternally(cause);
    }

    @Override
    public void setMainMailboxExecutor(MailboxExecutor mainMailboxExecutor) {
        Preconditions.checkState((this.mainMailboxExecutor == null ? 1 : 0) != 0, (Object)"Can not set mainMailboxExecutor twice!");
        this.mainMailboxExecutor = mainMailboxExecutor;
    }

    @Override
    public MailboxExecutor getMainMailboxExecutor() {
        return (MailboxExecutor)Preconditions.checkNotNull((Object)this.mainMailboxExecutor, (String)"mainMailboxExecutor has not been initialized yet!");
    }

    @Override
    public void setAsyncOperationsThreadPool(ExecutorService executorService) {
        Preconditions.checkState((this.asyncOperationsThreadPool == null ? 1 : 0) != 0, (Object)"Can not set asyncOperationsThreadPool twice!");
        this.asyncOperationsThreadPool = executorService;
    }

    @Override
    public ExecutorService getAsyncOperationsThreadPool() {
        return (ExecutorService)Preconditions.checkNotNull((Object)this.asyncOperationsThreadPool, (String)"asyncOperationsThreadPool has not been initialized yet!");
    }

    @Override
    public void setCheckpointStorageAccess(CheckpointStorageAccess checkpointStorageAccess) {
        Preconditions.checkState((this.checkpointStorageAccess == null ? 1 : 0) != 0, (Object)"Can not set checkpointStorageAccess twice!");
        this.checkpointStorageAccess = checkpointStorageAccess;
    }

    @Override
    public CheckpointStorageAccess getCheckpointStorageAccess() {
        return (CheckpointStorageAccess)Preconditions.checkNotNull((Object)this.checkpointStorageAccess, (String)"checkpointStorage has not been initialized yet!");
    }

    @Override
    public ChannelStateWriteRequestExecutorFactory getChannelStateExecutorFactory() {
        return this.channelStateExecutorFactory;
    }
}

